/*
 * Decompiled with CFR 0.152.
 */
package roguelike;

public class Item {
    public ItemType type;
    public int nCharges;

    public Item(ItemType type) {
        this.type = type;
        if (this.isPot()) {
            this.nCharges = 3;
        }
    }

    public String getIconName() {
        switch (this.type) {
            case ItemGreenTalisman: {
                return "ic_green_talisman";
            }
            case ItemBlueTalisman: {
                return "ic_blue_talisman";
            }
            case ItemRedTalisman: {
                return "ic_red_talisman";
            }
            case ItemHourglass: {
                return "ic_hourglass";
            }
            case ItemStaff: {
                return "ic_staff";
            }
            case ItemSelenicNecklace: {
                return "ic_moon_necklace";
            }
            case ItemTruesightWard: {
                return "ic_true_sight_ward";
            }
            case ItemAxe: {
                return "ic_axe";
            }
            case ItemSword: {
                return "ic_sword";
            }
            case ItemWizardRing: {
                return "ic_ring";
            }
            case ItemSoulStealer: {
                return "ic_mejais";
            }
            case ItemDodge: {
                return "ic_belt";
            }
            case ItemVampiricNecklace: {
                return "ic_vampire_necklace";
            }
            case ItemGreenPot: {
                return "ic_pot_green";
            }
            case ItemPurplePot: {
                return "ic_pot_purple";
            }
            case ItemBrownPot: {
                return "ic_pot_brown";
            }
            case ItemHeal: {
                return "ic_item_heal";
            }
            case ItemEnergize: {
                return "ic_item_mana";
            }
            case ItemScore: {
                return "ic_item_score";
            }
            case ItemAttack: {
                return "ic_item_ad";
            }
            case ItemDivineRapier: {
                return "ic_divine_rapier";
            }
            case ItemMaxStar: {
                return "ic_item_max_star";
            }
        }
        return "";
    }

    public String getDescription() {
        switch (this.type) {
            case ItemGreenTalisman: {
                return "Every time you kill a unit while silenced, gain 3 points";
            }
            case ItemBlueTalisman: {
                return "All your mana above 4 is converted into points";
            }
            case ItemRedTalisman: {
                return "When at 1 hp, get 2 points every time you cast a spell";
            }
            case ItemHourglass: {
                return "Killing an enemy with a tackle makes you invulnerable this turn";
            }
            case ItemStaff: {
                return "After using mana you get +1 attack next hit";
            }
            case ItemSelenicNecklace: {
                return "+1 mana per kill";
            }
            case ItemTruesightWard: {
                return "Reveal traps and chest hp. Consume to get +2 attack next hit";
            }
            case ItemAxe: {
                return "Gain +2 attack against treefolks and chests/mimics";
            }
            case ItemSword: {
                return "Gain +1 attack if there are 2 enemies or less on the map";
            }
            case ItemWizardRing: {
                return "Getting hit twice or more in 1 turn grants you 8 mana";
            }
            case ItemSoulStealer: {
                return "Gain +1 mana every turn if there are 4 or more enemies alive";
            }
            case ItemDodge: {
                return "When at 2 hp or less, you can only lose 1 hp per turn";
            }
            case ItemVampiricNecklace: {
                return "+1 hp per kill but your max hp becomes 3";
            }
            case ItemGreenPot: {
                return "Consume to remove silences and roots";
            }
            case ItemPurplePot: {
                return "Consume to gain +1 attack this level";
            }
            case ItemBrownPot: {
                return "Refresh a beast hability at random";
            }
            case ItemHeal: {
                return "Gain +1 hp";
            }
            case ItemEnergize: {
                return "Gain +2 mana";
            }
            case ItemScore: {
                return "Gain +1 point";
            }
            case ItemAttack: {
                return "Gain +2 attack next hit";
            }
            case ItemDivineRapier: {
                return "+1 attack, +2 score per kill, spells cost -1 mana";
            }
            case ItemMaxStar: {
                return "Gain +5 hp, +5 mana and +20 points";
            }
        }
        return "";
    }

    public boolean isUsable() {
        return this.type == ItemType.ItemPurplePot || this.type == ItemType.ItemBrownPot || this.type == ItemType.ItemGreenPot || this.type == ItemType.ItemTruesightWard;
    }

    public boolean isPot() {
        return this.type == ItemType.ItemPurplePot || this.type == ItemType.ItemBrownPot || this.type == ItemType.ItemGreenPot;
    }

    public boolean isImmediate() {
        return this.type == ItemType.ItemHeal || this.type == ItemType.ItemEnergize || this.type == ItemType.ItemScore || this.type == ItemType.ItemAttack || this.type == ItemType.ItemMaxStar;
    }

    public static enum ItemType {
        ItemGreenTalisman,
        ItemBlueTalisman,
        ItemRedTalisman,
        ItemGreenPot,
        ItemPurplePot,
        ItemBrownPot,
        ItemHourglass,
        ItemStaff,
        ItemSelenicNecklace,
        ItemTruesightWard,
        ItemAxe,
        ItemSword,
        ItemWizardRing,
        ItemSoulStealer,
        ItemDodge,
        ItemVampiricNecklace,
        ItemHeal,
        ItemEnergize,
        ItemScore,
        ItemAttack,
        ItemDivineRapier,
        ItemMaxStar;

    }
}

