/*
 * Decompiled with CFR 0.152.
 */
package roguelike;

import roguelike.DSprite;
import roguelike.SoundManager;
import roguelike.Unit;

public class Projectile
extends DSprite {
    private boolean friendly;
    public ProjectileType type;
    private float fadeTimer;
    public Unit target;

    public Projectile(ProjectileType type, boolean friendly, Unit target) {
        this.target = target;
        this.friendly = friendly;
        this.type = type;
        this.fadeTimer = -1.0f;
        String name = "";
        switch (type) {
            case DarkDagger: {
                name = "projectile_dagger.png";
                break;
            }
            case OozeHeal: {
                name = "projectile_heal.png";
                break;
            }
        }
        this.setImage(name);
    }

    public void update(float dt) {
        double dist;
        if (this.fadeTimer >= 0.0f) {
            this.fadeTimer += dt;
        }
        if ((dist = Math.sqrt(Math.pow(this.positionX - this.target.positionX, 2.0) + Math.pow(this.positionY - this.target.positionY, 2.0))) < 0.01) {
            return;
        }
        double dirX = (double)(this.target.positionX - this.positionX) / dist;
        double dirY = (double)(this.target.positionY - this.positionY) / dist;
        this.positionX = (float)((double)this.positionX + 12.0 * dirX * (double)dt);
        this.positionY = (float)((double)this.positionY + 12.0 * dirY * (double)dt);
    }

    public boolean isActive() {
        return this.fadeTimer < 0.0f;
    }

    public void fadeOut(boolean didHit) {
        if (this.fadeTimer >= 0.0f) {
            return;
        }
        this.positionX = this.target.positionX;
        this.positionY = this.target.positionY;
        this.fadeTimer = 0.0f;
        if (didHit) {
            String name = "";
            switch (this.type) {
                // Empty switch
            }
            SoundManager.getSharedManager().playSound(name);
        }
    }

    public boolean shouldRemove() {
        return this.fadeTimer > 0.4f;
    }

    public boolean isFriendly() {
        return this.friendly;
    }

    public static enum ProjectileType {
        DarkDagger,
        OozeHeal;

    }
}

