/*
 * Decompiled with CFR 0.152.
 */
package roguelike;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import roguelike.Item;

public class WaveManager {
    private static WaveManager sharedInstance;
    private ArrayList<Map<String, Integer>> enemiesByLevel = new ArrayList();
    private ArrayList<ArrayList<Item.ItemType>> itemsByLevel = new ArrayList();
    public static final String objEnemyTreefolk = "objEnemyTreefolk";
    public static final String objEnemyOoze = "objEnemyOoze";
    public static final String objEnemySnail = "objEnemySnail";
    public static final String objEnemyShroom = "objEnemyShroom";
    public static final String objEnemyChest = "objEnemyChest";
    public static final String objEnemySuperChest = "objEnemySuperChest";

    private WaveManager() {
    }

    public void randomizeRun() {
        this.enemiesByLevel.clear();
        this.itemsByLevel.clear();
        ArrayList<Integer> superChestLevels = new ArrayList<Integer>();
        int i = 1;
        while (i < 7) {
            if (i != 3) {
                superChestLevels.add(i);
            }
            ++i;
        }
        while (superChestLevels.size() > 2) {
            superChestLevels.remove((int)(Math.random() * (double)superChestLevels.size()));
        }
        int[] smallEnems = new int[]{2, 3, 3, 4, 4, 4, 4, 5, 5, 6};
        int[] nArray = new int[10];
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 1;
        nArray[9] = 1;
        int[] bigEnems = nArray;
        ArrayList<Item.ItemType> earlyItems = new ArrayList<Item.ItemType>();
        earlyItems.add(Item.ItemType.ItemSword);
        earlyItems.add(Item.ItemType.ItemAxe);
        earlyItems.add(Item.ItemType.ItemTruesightWard);
        earlyItems.add(Item.ItemType.ItemStaff);
        earlyItems.add(Item.ItemType.ItemSelenicNecklace);
        earlyItems.add(Item.ItemType.ItemHourglass);
        ArrayList<Item.ItemType> lateItems = new ArrayList<Item.ItemType>();
        lateItems.add(Item.ItemType.ItemSoulStealer);
        lateItems.add(Item.ItemType.ItemDodge);
        lateItems.add(Item.ItemType.ItemWizardRing);
        lateItems.add(Item.ItemType.ItemVampiricNecklace);
        ArrayList<Item.ItemType> scoreItems = new ArrayList<Item.ItemType>();
        scoreItems.add(Item.ItemType.ItemGreenTalisman);
        scoreItems.add(Item.ItemType.ItemRedTalisman);
        scoreItems.add(Item.ItemType.ItemBlueTalisman);
        ArrayList<Item.ItemType> consumableItems = new ArrayList<Item.ItemType>();
        consumableItems.add(Item.ItemType.ItemPurplePot);
        consumableItems.add(Item.ItemType.ItemPurplePot);
        consumableItems.add(Item.ItemType.ItemGreenPot);
        consumableItems.add(Item.ItemType.ItemGreenPot);
        consumableItems.add(Item.ItemType.ItemBrownPot);
        consumableItems.add(Item.ItemType.ItemBrownPot);
        int i2 = 0;
        while (i2 < 10) {
            HashMap<String, Integer> enemies = new HashMap<String, Integer>();
            ArrayList<Item.ItemType> items = new ArrayList<Item.ItemType>();
            enemies.put(objEnemyChest, 0);
            enemies.put(objEnemySuperChest, 0);
            if (i2 <= 6 && i2 != 3) {
                if (superChestLevels.size() > 0 && (Integer)superChestLevels.get(0) == i2) {
                    superChestLevels.remove(0);
                    enemies.put(objEnemySuperChest, 1);
                } else {
                    enemies.put(objEnemyChest, 1);
                }
            }
            enemies.put(objEnemyTreefolk, bigEnems[i2]);
            int nOoze = 0;
            int nShroom = 0;
            int nSnail = 0;
            int k = 0;
            while (k < smallEnems[i2]) {
                int r = (int)Math.floor(Math.random() * 3.0);
                if (r == 0) {
                    ++nOoze;
                } else if (r == 1) {
                    ++nShroom;
                } else if (r == 2) {
                    ++nSnail;
                }
                ++k;
            }
            enemies.put(objEnemyOoze, nOoze);
            enemies.put(objEnemyShroom, nShroom);
            enemies.put(objEnemySnail, nSnail);
            if (i2 <= 2 || i2 >= 4 && i2 <= 6) {
                int index;
                if (i2 != 6) {
                    index = (int)(Math.random() * (double)consumableItems.size());
                    items.add((Item.ItemType)((Object)consumableItems.get(index)));
                    consumableItems.remove(index);
                } else {
                    index = (int)(Math.random() * (double)lateItems.size());
                    items.add((Item.ItemType)((Object)lateItems.get(index)));
                    lateItems.remove(index);
                }
                if (i2 <= 2) {
                    index = (int)(Math.random() * (double)scoreItems.size());
                    items.add((Item.ItemType)((Object)scoreItems.get(index)));
                    scoreItems.remove(index);
                    index = (int)(Math.random() * (double)earlyItems.size());
                    items.add((Item.ItemType)((Object)earlyItems.get(index)));
                    earlyItems.remove(index);
                } else if (i2 >= 4 && i2 <= 6) {
                    index = (int)(Math.random() * (double)lateItems.size());
                    items.add((Item.ItemType)((Object)lateItems.get(index)));
                    lateItems.remove(index);
                    index = (int)(Math.random() * (double)earlyItems.size());
                    items.add((Item.ItemType)((Object)earlyItems.get(index)));
                    earlyItems.remove(index);
                }
            }
            this.enemiesByLevel.add(enemies);
            this.itemsByLevel.add(items);
            ++i2;
        }
    }

    public Map<String, Integer> getEnemies(int level) {
        return this.enemiesByLevel.get(level);
    }

    public ArrayList<Item.ItemType> getItems(int level) {
        return this.itemsByLevel.get(level);
    }

    public static WaveManager getSharedManager() {
        if (sharedInstance == null) {
            sharedInstance = new WaveManager();
        }
        return sharedInstance;
    }
}

