/*
 * Decompiled with CFR 0.152.
 */
package roguelike;

import java.awt.Point;
import roguelike.Element;

public class Unit
extends Element {
    protected float nextPosX;
    protected float nextPosY;
    public int lives;
    public int rootCount;
    protected float velocity = 6.0f;
    protected float[] tackleDestination = null;
    protected boolean shouldBeRemoved;
    protected int stunCount;

    public Unit(Element.ElementType type) {
        super(type);
    }

    public void update(float dt) {
        if (this.tackleDestination != null) {
            this.updateTackle(dt);
        } else {
            this.updateNormal(dt);
        }
    }

    private void updateTackle(float dt) {
        float dirX = this.tackleDestination[0] - this.positionX;
        float dirY = this.tackleDestination[1] - this.positionY;
        this.positionX += this.velocity * dt * dirX;
        this.positionY += this.velocity * dt * dirY;
        if (Point.distance(this.positionX, this.positionY, this.tackleDestination[0], this.tackleDestination[1]) < 0.5) {
            this.tackleDestination = null;
        }
    }

    private void updateNormal(float dt) {
        if (this.nextPosX - this.positionX > 0.0f) {
            this.positionX += this.velocity * dt;
            if (this.nextPosX - this.positionX < 0.0f) {
                this.positionX = this.nextPosX;
            }
        } else if (this.nextPosX - this.positionX < 0.0f) {
            this.positionX -= this.velocity * dt;
            if (this.nextPosX - this.positionX > 0.0f) {
                this.positionX = this.nextPosX;
            }
        }
        if (this.nextPosY - this.positionY > 0.0f) {
            this.positionY += this.velocity * dt;
            if (this.nextPosY - this.positionY < 0.0f) {
                this.positionY = this.nextPosY;
            }
        } else if (this.nextPosY - this.positionY < 0.0f) {
            this.positionY -= this.velocity * dt;
            if (this.nextPosY - this.positionY > 0.0f) {
                this.positionY = this.nextPosY;
            }
        }
    }

    @Override
    public int[] getSlot() {
        return new int[]{(int)this.nextPosX, (int)this.nextPosY};
    }

    public void moveTo(int[] pos) {
        this.nextPosX = pos[0];
        this.nextPosY = pos[1];
    }

    public void teleportTo(int[] pos) {
        this.positionX = pos[0];
        this.positionY = pos[1];
        this.nextPosX = pos[0];
        this.nextPosY = pos[1];
    }

    public void takeHit(int ad) {
        this.lives -= ad;
        if (this.lives <= 0) {
            this.shouldBeRemoved = true;
        }
    }

    public boolean shouldRemove() {
        return this.shouldBeRemoved;
    }

    public void stun() {
        this.stunCount = 4;
    }
}

