/*
 * Decompiled with CFR 0.152.
 */
package roguelike;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import roguelike.DSprite;
import roguelike.Enemy;
import roguelike.GameModel;
import roguelike.Hero;
import roguelike.Item;
import roguelike.SoundManager;
import roguelike.Unit;

public class Board
extends JPanel
implements ActionListener,
KeyListener,
MouseMotionListener {
    private final int DELAY = 50;
    private GameModel model;
    private GameState state;
    private Timer timer;
    private boolean isFullscreen;
    private int mouseX;
    private int mouseY;
    private HashMap<String, Image> icons;
    private final Color bgYellowColor = new Color(227, 172, 61);
    private final Color bgBoxColor = new Color(166, 125, 45);
    private final String title = "MARSH ADVENTURE";
    private final int HINT_INDEX = 101;
    private float endGameTimer;
    private Font copperplateFont;

    public Board() {
        this.setBackground(Color.black);
        this.addKeyListener(this);
        this.addMouseMotionListener(this);
        this.setFocusable(true);
        this.requestFocusInWindow();
        SoundManager.getSharedManager().preloadSounds();
        this.state = GameState.WaitingForStart;
        if (this.timer != null) {
            this.timer.stop();
        }
        this.timer = new Timer(50, this);
        this.timer.start();
        InputStream is = this.getClass().getResourceAsStream("/roguelike/data/Copperplate.ttf");
        try {
            this.copperplateFont = Font.createFont(0, is);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    private void initGame() {
        this.state = GameState.Playing;
        this.model = new GameModel();
        this.icons = new HashMap();
        this.icons.put("ic_heart", this.loadImage("ic_heart.png"));
        this.icons.put("ic_mana", this.loadImage("ic_mana.png"));
        this.icons.put("ic_dark_daggers", this.loadImage("ic_dark_daggers.png"));
        this.icons.put("ic_teleport", this.loadImage("ic_teleport.png"));
        this.icons.put("ic_silence_spark", this.loadImage("ic_silence_spark.png"));
        this.icons.put("ic_bear_smash", this.loadImage("ic_bear_smash.png"));
        this.icons.put("ic_tiger_slash", this.loadImage("ic_tiger_slash.png"));
        this.icons.put("ic_fire_punch", this.loadImage("ic_fire_punch.png"));
        this.icons.put("ic_hit_stack", this.loadImage("ic_hit_stack.png"));
        this.icons.put("ic_enemy_hp", this.loadImage("ic_enemy_hp.png"));
        this.icons.put("ic_no_deathrattle", this.loadImage("ic_no_deathrattle.png"));
        this.icons.put("ic_silence1", this.loadImage("ic_silence1.png"));
        this.icons.put("ic_silence2", this.loadImage("ic_silence2.png"));
        this.icons.put("ic_bear_counter", this.loadImage("ic_bear_counter.png"));
        this.icons.put("ic_slash_counter", this.loadImage("ic_slash_counter.png"));
        this.icons.put("ic_fire_counter", this.loadImage("ic_fire_counter.png"));
        this.icons.put("ic_vine", this.loadImage("ic_vine.png"));
        this.icons.put("ic_green_talisman", this.loadImage("ic_green_talisman.png"));
        this.icons.put("ic_blue_talisman", this.loadImage("ic_blue_talisman.png"));
        this.icons.put("ic_red_talisman", this.loadImage("ic_red_talisman.png"));
        this.icons.put("ic_hourglass", this.loadImage("ic_hourglass.png"));
        this.icons.put("ic_axe", this.loadImage("ic_axe.png"));
        this.icons.put("ic_moon_necklace", this.loadImage("ic_moon_necklace.png"));
        this.icons.put("ic_true_sight_ward", this.loadImage("ic_true_sight_ward.png"));
        this.icons.put("ic_vampire_necklace", this.loadImage("ic_vampire_necklace.png"));
        this.icons.put("ic_sword", this.loadImage("ic_sword.png"));
        this.icons.put("ic_ring", this.loadImage("ic_ring.png"));
        this.icons.put("ic_mejais", this.loadImage("ic_mejais.png"));
        this.icons.put("ic_belt", this.loadImage("ic_belt.png"));
        this.icons.put("ic_staff", this.loadImage("ic_staff.png"));
        this.icons.put("ic_pot_green", this.loadImage("ic_pot_green.png"));
        this.icons.put("ic_pot_purple", this.loadImage("ic_pot_purple.png"));
        this.icons.put("ic_pot_brown", this.loadImage("ic_pot_brown.png"));
        this.icons.put("ic_item_heal", this.loadImage("ic_item_heal.png"));
        this.icons.put("ic_item_mana", this.loadImage("ic_item_mana.png"));
        this.icons.put("ic_item_score", this.loadImage("ic_item_score.png"));
        this.icons.put("ic_item_ad", this.loadImage("ic_item_ad.png"));
        this.icons.put("ic_item_max_star", this.loadImage("ic_item_max_star.png"));
        this.icons.put("ic_divine_rapier", this.loadImage("ic_divine_rapier.png"));
    }

    private Image loadImage(String name) {
        ImageIcon ii = new ImageIcon(DSprite.class.getResource("data/" + name));
        return ii.getImage();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.doDrawing(g);
    }

    private void doDrawing(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int h = this.getSize().height;
        int w = (int)(800.0 * (double)h / 600.0);
        g.translate((this.getSize().width - w) / 2, 0);
        int u = (int)((double)h * 0.1);
        if (this.state == GameState.WaitingForStart) {
            g.setColor(new Color(22, 36, 9));
            g.fillRect(0, 0, w, h);
            int titleH = (int)(0.8 * (double)u);
            int instH = (int)(0.35 * (double)u);
            int footerH = (int)(0.3 * (double)u);
            g.setColor(new Color(200, 200, 200));
            this.drawString(g, "MARSH ADVENTURE", (int)(0.5 * (double)u), (int)(1.0 * (double)u), titleH);
            this.drawString(g, "Druid Form:", (int)(0.5 * (double)u), (int)(3.0 * (double)u), instH);
            this.drawString(g, "* 3 points per kill", (int)(4.5 * (double)u), (int)(3.0 * (double)u), instH);
            this.drawString(g, "* casting spells costs mana", (int)(4.5 * (double)u), (int)(3.8 * (double)u), instH);
            this.drawString(g, "Beast Form:", (int)(0.5 * (double)u), (int)(5.0 * (double)u), instH);
            this.drawString(g, "* +1 hp and +3 mana every 4 hits", (int)(4.5 * (double)u), (int)(5.0 * (double)u), instH);
            this.drawString(g, "* cast spells once per transform", (int)(4.5 * (double)u), (int)(5.8 * (double)u), instH);
            this.drawString(g, "* can cast through roots", (int)(4.5 * (double)u), (int)(6.6 * (double)u), instH);
            this.drawString(g, "* collect enemy souls for score", (int)(4.5 * (double)u), (int)(7.4 * (double)u), instH);
            this.drawString(g, "by @diego_cath", (int)(0.5 * (double)u), (int)(9.8 * (double)u), footerH);
        } else if (this.state == GameState.Playing) {
            Image img;
            Hero hero = this.model.getHero();
            g.setColor(this.bgYellowColor);
            g.fillRect(0, 0, w, h);
            double alpha = (double)h / 600.0;
            int blockDim = (int)(120.0 * alpha);
            int blockDimExt = (int)(135.0 * alpha);
            int marginX = (int)(75.0 * alpha);
            int marginY = (int)(100.0 * alpha);
            g.translate(0, this.model.getBoardY());
            g.translate(marginX, marginY);
            g.setColor(new Color(14, 23, 6));
            g.fillRect(0, 0, (int)(450.0 * alpha), (int)(450.0 * alpha));
            g.setColor(new Color(77, 49, 31));
            g.fillRect((int)(10.0 * alpha), (int)(10.0 * alpha), (int)(430.0 * alpha), (int)(430.0 * alpha));
            g.translate((int)(25.0 * alpha), (int)(25.0 * alpha));
            g.setColor(new Color(123, 161, 90));
            int i = 0;
            while (i < 3) {
                int j = 0;
                while (j < 3) {
                    this.drawFloorTile(g, this.model.tileColor[i][j], (int)((double)(140 * i) * alpha), (int)((double)(140 * j) * alpha), blockDim, blockDim);
                    ++j;
                }
                ++i;
            }
            float xMid = 140 * this.model.markPosition[0] + 60;
            float yMid = 140 * this.model.markPosition[1] + 60;
            g.drawImage(this.icons.get("ic_teleport"), (int)((double)xMid + (double)blockDim * 0.5 - 34.0 * alpha), (int)((double)yMid - (double)blockDim * 0.5 + 5.0 * alpha), null);
            ArrayList<DSprite> sprites = this.model.getSprites();
            for (DSprite s : sprites) {
                img = s.getImage();
                int imgW = (int)((double)img.getWidth(null) * alpha);
                int imgH = (int)((double)img.getHeight(null) * alpha);
                float[] position = s.getPosition();
                int[] delta = s.getDrawDelta();
                xMid = 140.0f * position[0] + 60.0f;
                yMid = 140.0f * position[1] + 60.0f;
                g.drawImage(img, (int)(((double)xMid - (double)imgW / 2.0 + (double)delta[0]) * alpha), (int)(((double)yMid - (double)imgH / 2.0 + (double)delta[1]) * alpha), imgW, imgH, this);
                if (s instanceof Enemy) {
                    Enemy enemy = (Enemy)s;
                    if (enemy.shouldDrawHP() || hero.hasItemOfType(Item.ItemType.ItemTruesightWard)) {
                        int i2 = 0;
                        while (i2 < enemy.lives) {
                            g.drawImage(this.icons.get("ic_enemy_hp"), (int)((double)xMid + (double)blockDim * 0.5 - (double)(15 * (i2 + 1)) * alpha), (int)((double)yMid - (double)blockDim * 0.5 + 5.0 * alpha), null);
                            ++i2;
                        }
                    }
                    if (!enemy.deathrattleAvailable) {
                        g.drawImage(this.icons.get("ic_no_deathrattle"), (int)((double)xMid - (double)blockDim * 0.5 + 5.0 * alpha), (int)((double)yMid - (double)blockDim * 0.5 + 5.0 * alpha), null);
                    }
                }
                if (s instanceof Hero) {
                    if (hero.silenceCounter > 0) {
                        String fileName = "ic_silence" + hero.silenceCounter;
                        g.drawImage(this.icons.get(fileName), (int)((double)xMid + (double)blockDim * 0.5 - 34.0 * alpha), (int)((double)yMid - (double)blockDim * 0.5 + 5.0 * alpha), null);
                    }
                    int i3 = 0;
                    while (i3 < hero.attackIDs.size()) {
                        String fileName = "";
                        if (hero.attackIDs.get(i3).equals("Q")) {
                            fileName = "ic_bear_counter";
                        } else if (hero.attackIDs.get(i3).equals("W")) {
                            fileName = "ic_slash_counter";
                        } else if (hero.attackIDs.get(i3).equals("E")) {
                            fileName = "ic_fire_counter";
                        }
                        g.drawImage(this.icons.get(fileName), (int)((double)xMid - (double)blockDim * 0.5 + 5.0 * alpha), (int)((double)yMid - (double)blockDim * 0.5 + (double)(2 + 20 * i3) * alpha), null);
                        ++i3;
                    }
                }
                if (!(s instanceof Unit)) continue;
                Unit unit = (Unit)s;
                if (unit.rootCount == 1) {
                    g.drawImage(this.icons.get("ic_vine"), (int)((double)xMid - (double)imgW / 2.0), (int)((double)yMid - (double)imgH / 2.0), null);
                    continue;
                }
                if (unit.rootCount != 2) continue;
                g.drawImage(this.icons.get("ic_vine"), (int)((double)xMid - (double)imgW / 2.0), (int)((double)yMid - (double)imgH / 2.0 - 8.0 * alpha), null);
                g.drawImage(this.icons.get("ic_vine"), (int)((double)xMid - (double)imgW / 2.0), (int)((double)yMid - (double)imgH / 2.0 + 8.0 * alpha), null);
            }
            g.translate(0, -this.model.getBoardY());
            int uiFontSize = (int)(15.0 * alpha);
            g.translate((int)(445.0 * alpha), 0);
            g.setColor(this.bgBoxColor);
            g.fillRect(0, 0, (int)(230.0 * alpha), (int)(40.0 * alpha));
            this.drawString(g, "Level " + this.model.getLevel() + " of " + 10, (int)(15.0 * alpha), (int)(27.0 * alpha), uiFontSize, Color.BLACK);
            g.fillRect(0, (int)(50.0 * alpha), (int)(110.0 * alpha), (int)(40.0 * alpha));
            g.drawImage(this.icons.get("ic_heart"), (int)(15.0 * alpha), (int)(60.0 * alpha), null);
            this.drawString(g, "x" + hero.lives, (int)(50.0 * alpha), (int)(75.0 * alpha), uiFontSize, Color.BLACK);
            g.fillRect((int)(120.0 * alpha), (int)(50.0 * alpha), (int)(110.0 * alpha), (int)(40.0 * alpha));
            g.drawImage(this.icons.get("ic_mana"), (int)(135.0 * alpha), (int)(60.0 * alpha), null);
            this.drawString(g, "x" + hero.mana, (int)(170.0 * alpha), (int)(75.0 * alpha), uiFontSize, Color.BLACK);
            g.fillRect(0, (int)(100.0 * alpha), (int)(230.0 * alpha), (int)(40.0 * alpha));
            this.drawString(g, "Score: " + hero.score, (int)(15.0 * alpha), (int)(127.0 * alpha), uiFontSize, Color.BLACK);
            this.drawItemBox(g, null, 'r', 0, (int)(150.0 * alpha), (int)(230.0 * alpha), (int)(40.0 * alpha), hero.transformAvailable && hero.silenceCounter == 0);
            this.drawString(g, "Transform", (int)(15.0 * alpha), (int)(177.0 * alpha), uiFontSize, Color.BLACK);
            this.drawItemBox(g, this.icons.get("ic_dark_daggers"), 'q', 0, (int)(200.0 * alpha), (int)(70.0 * alpha), (int)(40.0 * alpha), hero.currentForm == 0 && hero.silenceCounter == 0);
            this.drawItemBox(g, this.icons.get("ic_teleport"), 'w', (int)(80.0 * alpha), (int)(200.0 * alpha), (int)(70.0 * alpha), (int)(40.0 * alpha), hero.currentForm == 0 && hero.silenceCounter == 0);
            this.drawItemBox(g, this.icons.get("ic_silence_spark"), 'e', (int)(160.0 * alpha), (int)(200.0 * alpha), (int)(70.0 * alpha), (int)(40.0 * alpha), hero.currentForm == 0 && hero.silenceCounter == 0);
            this.drawItemBox(g, this.icons.get("ic_bear_smash"), 'q', 0, (int)(250.0 * alpha), (int)(70.0 * alpha), (int)(40.0 * alpha), hero.beastQAvailable && hero.currentForm == 1 && hero.silenceCounter == 0);
            this.drawItemBox(g, this.icons.get("ic_tiger_slash"), 'w', (int)(80.0 * alpha), (int)(250.0 * alpha), (int)(70.0 * alpha), (int)(40.0 * alpha), hero.beastWAvailable && hero.currentForm == 1 && hero.silenceCounter == 0);
            this.drawItemBox(g, this.icons.get("ic_fire_punch"), 'e', (int)(160.0 * alpha), (int)(250.0 * alpha), (int)(70.0 * alpha), (int)(40.0 * alpha), hero.beastEAvailable && hero.currentForm == 1 && hero.silenceCounter == 0);
            int i4 = 0;
            while (i4 < 3) {
                int nCharges;
                img = null;
                if (i4 < hero.items.size()) {
                    img = this.icons.get(hero.items.get(i4).getIconName());
                }
                this.drawItemBox(g, img, ("" + (i4 + 1)).charAt(0), (int)((double)(80 * i4) * alpha), (int)(300.0 * alpha), (int)(70.0 * alpha), (int)(40.0 * alpha), true);
                if (i4 < hero.items.size() && (nCharges = hero.items.get((int)i4).nCharges) > 0) {
                    this.drawString(g, "x" + nCharges, (int)((double)(80 * i4 + 52) * alpha), (int)(312.0 * alpha), 11, Color.BLACK);
                }
                ++i4;
            }
            g.setColor(this.bgBoxColor);
            g.fillRect(0, (int)(350.0 * alpha), (int)(230.0 * alpha), (int)(40.0 * alpha));
            this.drawString(g, "Hit stacks:", (int)(15.0 * alpha), (int)(377.0 * alpha), uiFontSize, Color.BLACK);
            i4 = 0;
            while (i4 < hero.hitStacks) {
                g.drawImage(this.icons.get("ic_hit_stack"), (int)((double)(140 + i4 * 20) * alpha), (int)(360.0 * alpha), null);
                ++i4;
            }
            int ad = hero.ad + hero.tempAD;
            if (this.model.enemies.size() <= 2 && hero.hasItemOfType(Item.ItemType.ItemSword)) {
                ++ad;
            }
            if (hero.hasItemOfType(Item.ItemType.ItemDivineRapier)) {
                ++ad;
            }
            if (ad > 1) {
                this.drawString(g, "attack damage: " + ad, (int)(15.0 * alpha), (int)(427.0 * alpha), uiFontSize, Color.BLACK);
            }
            if (this.model.dialogue.visible) {
                g.translate((int)(-470.0 * alpha - (double)marginX), (int)(-25.0 * alpha - (double)marginY));
                if (this.model.dialogue.visible) {
                    this.model.dialogue.draw(g, new Rectangle(0, 0, w, h), this.icons);
                }
            } else {
                g.translate(-((int)(470.0 * alpha)), (int)(460.0 * alpha));
                int x = (int)Math.floor(((double)this.mouseX - 92.5 * alpha) / (double)blockDimExt);
                int y = (int)Math.floor(((double)this.mouseY - 117.5 * alpha) / (double)blockDimExt);
                String desc = "";
                if (x >= 0 && x < 3 && y >= 0 && y < 3) {
                    desc = this.model.getDescriptionAt(x, y);
                } else if ((double)this.mouseX > 545.0 * alpha && (double)this.mouseX < 775.0 * alpha) {
                    if ((double)this.mouseY > 275.0 * alpha && (double)this.mouseY < 315.0 * alpha) {
                        if (!this.model.getHero().transformAvailable) {
                            desc = "Kill an enemy to enable";
                        }
                    } else if ((double)this.mouseY > 325.0 * alpha && (double)this.mouseY < 365.0 * alpha) {
                        int deltaMana = 0;
                        if (this.model.getHero().hasItemOfType(Item.ItemType.ItemDivineRapier)) {
                            deltaMana = 1;
                        }
                        if ((double)this.mouseX > 545.0 * alpha && (double)this.mouseX < 615.0 * alpha) {
                            desc = String.valueOf(4 - deltaMana) + " mana: throw daggers to the 3 healthiest enemies";
                        } else if ((double)this.mouseX > 625.0 * alpha && (double)this.mouseX < 695.0 * alpha) {
                            desc = String.valueOf(3 - deltaMana) + " mana: teleport to the mark, then hit and root adjacent enemies";
                        } else if ((double)this.mouseX > 705.0 * alpha && (double)this.mouseX < 775.0 * alpha) {
                            desc = String.valueOf(4 - deltaMana) + " mana: hit aligned enemies. They lose their death effects";
                        }
                    } else if ((double)this.mouseY > 375.0 * alpha && (double)this.mouseY < 415.0 * alpha) {
                        if ((double)this.mouseX > 545.0 * alpha && (double)this.mouseX < 615.0 * alpha) {
                            desc = "Queue attack: 2 free actions. Hitting enemies will root them";
                        } else if ((double)this.mouseX > 625.0 * alpha && (double)this.mouseX < 695.0 * alpha) {
                            desc = "Queue attack: hit an enemy 3 times";
                        } else if ((double)this.mouseX > 705.0 * alpha && (double)this.mouseX < 775.0 * alpha) {
                            desc = "Queue attack: burn hit enemy and all adjacent monsters";
                        }
                    } else if ((double)this.mouseY > 425.0 * alpha && (double)this.mouseY < 465.0 * alpha) {
                        int i5 = 0;
                        while (i5 < 3) {
                            if ((double)this.mouseX > (double)(545 + 80 * i5) * alpha && (double)this.mouseX < (double)(615 + 80 * i5) * alpha && hero.items.size() >= i5 + 1) {
                                desc = hero.items.get(i5).getDescription();
                            }
                            ++i5;
                        }
                    } else if ((double)this.mouseY > 475.0 * alpha && (double)this.mouseY < 515.0 * alpha) {
                        desc = "Earn by attacking as beast. At 4 stacks you gain +1 hp and +3 mana";
                    }
                }
                if (desc != null) {
                    this.drawString(g, desc, 0, (int)(0.0 * alpha), uiFontSize, Color.BLACK);
                }
            }
        } else if (this.model.getHero().lives > 0) {
            g.setColor(this.bgYellowColor);
            g.fillRect(0, 0, w, h);
            int titleH = (int)(0.8 * (double)u);
            int instH = (int)(0.35 * (double)u);
            this.drawString(g, "Victory!", (int)(4.5 * (double)u), (int)(1.1 * (double)u), titleH, new Color(10, 10, 10));
            this.drawString(g, "final score: " + this.model.getHero().score, (int)(5.0 * (double)u), (int)(3.8 * (double)u), instH, new Color(10, 10, 10));
            int i = 0;
            while (i < 3) {
                Image img = null;
                if (i < this.model.getHero().items.size()) {
                    img = this.icons.get(this.model.getHero().items.get(i).getIconName());
                }
                this.drawItemBox(g, img, ("" + (i + 1)).charAt(0), 265 + 100 * i, 320, 70, 40, true);
                ++i;
            }
        } else {
            g.setColor(new Color(22, 36, 9));
            g.fillRect(0, 0, w, h);
            int titleH = (int)(0.8 * (double)u);
            int instH = (int)(0.35 * (double)u);
            int footerH = (int)(0.3 * (double)u);
            g.setColor(new Color(200, 200, 200));
            this.drawString(g, "Defeat", (int)(4.8 * (double)u), (int)(1.0 * (double)u), titleH);
            if (this.model.getHero().score > 50) {
                ArrayList<String> phraseLines = this.getAnnoyingPhrase();
                int i = 0;
                while (i < phraseLines.size()) {
                    String s = phraseLines.get(i);
                    this.drawString(g, s, (int)(3.0 * (double)u), (int)((3.8 + 0.8 * (double)i) * (double)u), instH);
                    ++i;
                }
            } else {
                this.drawString(g, "final score: " + this.model.getHero().score, (int)(5.1 * (double)u), (int)(5.0 * (double)u), instH);
            }
            this.drawString(g, "Press enter to continue", (int)(4.3 * (double)u), (int)(9.8 * (double)u), footerH);
        }
        Toolkit.getDefaultToolkit().sync();
        g.dispose();
    }

    private void drawFloorTile(Graphics g, int index, int x, int y, int w, int h) {
        Color color = new Color(0, 0, 0);
        switch (index) {
            case 0: {
                color = new Color(77, 128, 33);
                break;
            }
            case 1: {
                color = new Color(97, 161, 42);
                break;
            }
            case 2: {
                color = new Color(70, 94, 49);
                break;
            }
            case 3: {
                color = new Color(123, 161, 90);
                break;
            }
            case 4: {
                color = new Color(65, 128, 12);
                break;
            }
            case 101: {
                color = new Color(250, 250, 250, 200);
            }
        }
        if (this.model.secretLevel) {
            int n = (int)(100.0 + 100.0 * ((double)index / 4.0));
            color = new Color(n, n, n);
        }
        g.setColor(color);
        g.fillRect(x, y, w, h);
    }

    private void drawItemBox(Graphics g, Image img, char keyName, int x, int y, int w, int h, boolean available) {
        g.setColor(this.bgBoxColor);
        g.fillRect(x, y, w, h);
        if (img != null) {
            g.drawImage(img, x + w / 2 - img.getWidth(null) / 2, y + h / 2 - img.getHeight(null) / 2, null);
        }
        if (!available) {
            g.setColor(new Color(0, 0, 0, 150));
            g.fillRect(x, y, w, h);
        }
        g.setColor(this.bgYellowColor);
        g.fillRect(x + w - 10, y + h - 10, 10, 10);
        g.setColor(Color.BLACK);
        g.setFont(this.copperplateFont.deriveFont(12.0f));
        g.drawString("" + keyName, x + w - 9, y + h - 1);
    }

    private void drawString(Graphics g, String s, int x, int y, int h) {
        this.drawString(g, s, x, y, h, new Color(255, 255, 255));
    }

    private void drawString(Graphics g, String s, int x, int y, int h, Color color) {
        Color c = g.getColor();
        g.setFont(this.copperplateFont.deriveFont((float)h));
        g.setColor(color);
        g.drawString(s, x, y);
        g.setColor(c);
    }

    private JFrame getFrame() {
        return (JFrame)SwingUtilities.getWindowAncestor(this);
    }

    public void setFullScreen(boolean fullScreen) {
        this.isFullscreen = fullScreen;
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        JFrame f = this.getFrame();
        if (gd.isFullScreenSupported() && fullScreen) {
            f.dispose();
            f.setSize(screenSize);
            f.setUndecorated(true);
            f.setLocation(0, 0);
            gd.setFullScreenWindow(f);
            f.setVisible(true);
        } else {
            Window w = gd.getFullScreenWindow();
            if (w != null) {
                w.dispose();
            }
            gd.setFullScreenWindow(null);
            f.dispose();
            f.setSize(f.getMinimumSize());
            f.setUndecorated(false);
            f.setLocation((screenSize.width - f.getSize().width) / 2, (screenSize.height - f.getSize().height) / 2);
            f.setVisible(true);
        }
    }

    public void setMouseVisible(boolean v) {
        if (v) {
            this.getFrame().getContentPane().setCursor(Cursor.getDefaultCursor());
        } else {
            BufferedImage cursorImg = new BufferedImage(16, 16, 2);
            Cursor blankCursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorImg, new Point(0, 0), "blank cursor");
            this.setCursor(blankCursor);
        }
    }

    public ArrayList<String> getAnnoyingPhrase() {
        int score = this.model.getHero().score;
        ArrayList<String> ret = new ArrayList<String>();
        if (this.model.getLevel() == 10 && this.model.enemies.size() <= 3) {
            ret.add("Close game, ggwp");
            ret.add("Final score = " + score);
        } else if (this.model.killer.equals("Shroom")) {
            ret.add("A mushroom just killed you with");
            ret.add("a tackle, you lose 50 points.");
            ret.add("Final score = " + (score - 50));
        } else {
            int rand = score % 2;
            if (rand == 0) {
                ret.add("You collected " + score + " points but");
                ret.add("it's no use when you are buried");
                ret.add("in a swamp");
            } else {
                ret.add("You gained " + score + " points but");
                ret.add("then a " + this.model.killer + " killed you");
                ret.add(":-(");
            }
        }
        return ret;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        float dt = 50.0f / 1000.0f;
        if (this.state == GameState.Playing) {
            this.model.update(dt);
            if (this.endGameTimer > 0.0f) {
                this.endGameTimer -= dt;
                if (this.endGameTimer <= 0.0f) {
                    this.state = GameState.GameEnded;
                }
            } else if (this.model.getLevel() > 10 || this.model.getHero().lives <= 0) {
                this.endGameTimer = 0.2f;
            }
        }
        this.repaint();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() != 27) {
            if (this.state == GameState.WaitingForStart) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                    this.initGame();
                }
            } else if (this.state == GameState.Playing) {
                if (e.getKeyCode() == 37) {
                    this.model.moveHero(3);
                } else if (e.getKeyCode() == 39) {
                    this.model.moveHero(1);
                } else if (e.getKeyCode() == 38) {
                    this.model.moveHero(0);
                } else if (e.getKeyCode() == 40) {
                    this.model.moveHero(2);
                } else if (e.getKeyCode() == 49) {
                    this.model.castSpell('1');
                } else if (e.getKeyCode() == 50) {
                    this.model.castSpell('2');
                } else if (e.getKeyCode() == 51) {
                    this.model.castSpell('3');
                } else if (e.getKeyCode() == 81) {
                    this.model.castSpell('Q');
                } else if (e.getKeyCode() == 87) {
                    this.model.castSpell('W');
                } else if (e.getKeyCode() == 69) {
                    this.model.castSpell('E');
                } else if (e.getKeyCode() == 82) {
                    this.model.castSpell('R');
                } else if (e.getKeyCode() == 10) {
                    this.model.enterPressed();
                }
            } else if (this.state == GameState.GameEnded && (e.getKeyCode() == 10 || e.getKeyCode() == 32)) {
                this.state = GameState.WaitingForStart;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseX = e.getPoint().x;
        this.mouseY = e.getPoint().y;
    }

    public static enum GameState {
        WaitingForStart,
        Playing,
        GameEnded;

    }
}

