/*
 * Decompiled with CFR 0.152.
 */
package roguelike;

import java.util.ArrayList;
import roguelike.Element;
import roguelike.Global;
import roguelike.Item;
import roguelike.SoundManager;
import roguelike.Unit;

public class Hero
extends Unit {
    public int mana;
    public int shields;
    public int score;
    public int ad;
    public int tempAD;
    public static final int DRUID_FORM = 0;
    public static final int BEAST_FORM = 1;
    public int currentForm = 0;
    public ArrayList<String> attackIDs;
    public boolean beastQAvailable;
    public boolean beastWAvailable;
    public boolean beastEAvailable;
    public boolean transformAvailable = true;
    public int hpLostThisTurn;
    public int hitsTakenThisTurn;
    public boolean invulnerable;
    public ArrayList<Item> items;
    public int silenceCounter;
    public int hitStacks;

    public Hero() {
        super(Element.ElementType.kTypeHero);
        this.lives = 3;
        this.mana = 5;
        this.drawDeltaY = -3;
        this.setImage("hero_druid.png");
        this.attackIDs = new ArrayList();
        this.items = new ArrayList();
    }

    public void addShields(int nShields) {
        this.shields = Math.min(4, this.shields + nShields);
        this.shields = 0;
    }

    public void addHitStack() {
        ++this.hitStacks;
        if (this.hitStacks == 4) {
            ++this.lives;
            this.addMana(3);
            this.hitStacks = 0;
        }
    }

    public void moveTo(float nextPosX, float nextPosY) {
        this.nextPosX = nextPosX;
        this.nextPosY = nextPosY;
        SoundManager.getSharedManager().playSound("move.wav");
    }

    public void setNextPos(float posX, float posY) {
        this.nextPosX = posX;
        this.nextPosY = posY;
    }

    public void tackle(int dir) {
        this.tackleDestination = new float[]{this.getSlot()[0] + Global.getVectorFromDir(dir)[0], this.getSlot()[1] + Global.getVectorFromDir(dir)[1]};
        SoundManager.getSharedManager().playSound("hit.wav");
    }

    public boolean hasItemOfType(Item.ItemType type) {
        for (Item i : this.items) {
            if (i.type != type) continue;
            return true;
        }
        return false;
    }

    public void addMana(int nMana) {
        this.mana += nMana;
        if (this.mana > 4 && this.hasItemOfType(Item.ItemType.ItemBlueTalisman)) {
            this.score += this.mana - 4;
            this.mana = 4;
        }
    }

    public void addLife(int nLives) {
        this.lives += nLives;
        if (this.lives > 3 && this.hasItemOfType(Item.ItemType.ItemVampiricNecklace)) {
            this.lives = 3;
        }
    }
}

