/*
 * Decompiled with CFR 0.152.
 */
package roguelike;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class ColorManager {
    private static ColorManager sharedInstance;
    private Map<String, Color[][]> colorModels = new HashMap<String, Color[][]>();

    private ColorManager() {
        try {
            String s;
            BufferedReader br = new BufferedReader(new InputStreamReader(ColorManager.class.getResourceAsStream("data/Color Models.txt")));
            HashMap<Character, Color> colors = new HashMap<Character, Color>();
            colors.put(Character.valueOf('.'), null);
            while (!(s = br.readLine()).equals("")) {
                char c = s.charAt(0);
                int r = Integer.parseInt(s.substring(2, s.indexOf(44)));
                int g = Integer.parseInt(s.substring(s.indexOf(44) + 1, s.indexOf(44, s.indexOf(44) + 1)));
                int b = Integer.parseInt(s.substring(s.indexOf(44, s.indexOf(44) + 1) + 1));
                colors.put(Character.valueOf(c), new Color(r, g, b));
            }
            while ((s = br.readLine()) != null) {
                String key = s;
                Color[][] color = new Color[8][8];
                int j = 0;
                while ((s = br.readLine()) != null && !s.equals("")) {
                    int i = 0;
                    while (i < s.length()) {
                        color[i][j] = (Color)colors.get(Character.valueOf(s.charAt(i)));
                        ++i;
                    }
                    ++j;
                }
                this.colorModels.put(key, color);
            }
            br.close();
        }
        catch (Exception ex) {
            System.out.println("Error abriendo Color Models.txt");
        }
    }

    public Color[][] getColorModel(String spriteName) {
        Color[][] ret = new Color[8][8];
        Color[][] color = this.colorModels.get(spriteName);
        int i = 0;
        while (i < 8) {
            int j = 0;
            while (j < 8) {
                if (color[i][j] != null) {
                    ret[i][j] = color[i][j];
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public Color[][] getColorModel(String spriteName, Color oneColor) {
        Color[][] color = this.getColorModel(spriteName);
        int i = 0;
        while (i < color.length) {
            int j = 0;
            while (j < color[0].length) {
                if (color[i][j] != null) {
                    color[i][j] = oneColor;
                }
                ++j;
            }
            ++i;
        }
        return color;
    }

    public Color[][] getColorModel(String spriteName, Color oldColor, Color newColor) {
        Color[][] color = this.getColorModel(spriteName);
        int i = 0;
        while (i < color.length) {
            int j = 0;
            while (j < color[0].length) {
                if (color[i][j] != null && color[i][j].getRed() == oldColor.getRed() && color[i][j].getGreen() == oldColor.getGreen() && color[i][j].getBlue() == oldColor.getBlue()) {
                    color[i][j] = newColor;
                }
                ++j;
            }
            ++i;
        }
        return color;
    }

    public static ColorManager getSharedManager() {
        if (sharedInstance == null) {
            sharedInstance = new ColorManager();
        }
        return sharedInstance;
    }
}

