/*
 * Decompiled with CFR 0.152.
 */
package roguelike;

import roguelike.ColorManager;
import roguelike.Element;
import roguelike.MagicTile;

public class Collectable
extends Element {
    public MagicTile.TileType tileType;

    public Collectable(MagicTile.TileType type) {
        super(Element.ElementType.kTypeGem);
        this.tileType = type;
        this.colorModel = ColorManager.getSharedManager().getColorModel("Gem", MagicTile.getColorByType(type));
    }

    @Override
    public String getDescription() {
        String retVal = "";
        switch (this.tileType) {
            case Fireball: {
                retVal = "Fireball gem.";
                break;
            }
            case OffensiveStance: {
                retVal = "Combat Stance gem.";
                break;
            }
            case Lightning: {
                retVal = "Lightning gem.";
                break;
            }
            case DefensiveStance: {
                retVal = "Defensive Stance gem.";
                break;
            }
            case Shield: {
                retVal = "Shield gem.";
                break;
            }
            case Teleport: {
                retVal = "Teleport gem.";
                break;
            }
            case QuickStance: {
                retVal = "Quick Stance gem.";
                break;
            }
            case Freeze: {
                retVal = "Freeze gem.";
                break;
            }
            case Dash: {
                retVal = "Dash gem.";
                break;
            }
            default: {
                retVal = "Woops.";
            }
        }
        return retVal;
    }
}

