/*
 * Decompiled with CFR 0.152.
 */
package roguelike;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Map;
import roguelike.Collectable;
import roguelike.ColorManager;
import roguelike.DSprite;
import roguelike.Element;
import roguelike.Enemy;
import roguelike.EnemyBasic;
import roguelike.EnemyQuick;
import roguelike.EnemyRanged;
import roguelike.Global;
import roguelike.Hero;
import roguelike.MagicTile;
import roguelike.MapManager;
import roguelike.Projectile;
import roguelike.SoundManager;
import roguelike.Unit;
import roguelike.Wall;
import roguelike.WaveManager;

public class GameModel
implements MapManager {
    private Hero hero;
    private DSprite portal;
    private ArrayList<Unit> units;
    private ArrayList<Element> statics;
    private ArrayList<Projectile> projectiles;
    private ArrayList<MagicTile> tiles;
    private ArrayList<int[]> blackTiles;
    private ArrayList<int[]> nonBlackTiles;
    private ArrayList<Collectable> ownedGems;
    private ArrayList<float[]> allSlots;
    private ArrayList<float[]> borderSlots;
    private ArrayList<float[]> innerSlots;
    private float blockTime;
    private float enemyTurnTimer;
    private float blackTileTimer;
    private int currentLevel;
    private boolean advancingLevel;

    public GameModel() {
        int j;
        WaveManager.getSharedManager().randomizeRun();
        this.hero = new Hero();
        this.portal = new DSprite(ColorManager.getSharedManager().getColorModel("Portal"));
        this.units = new ArrayList();
        this.statics = new ArrayList();
        this.tiles = new ArrayList();
        this.projectiles = new ArrayList();
        this.blackTiles = new ArrayList();
        this.nonBlackTiles = new ArrayList();
        this.ownedGems = new ArrayList();
        this.allSlots = new ArrayList();
        this.borderSlots = new ArrayList();
        this.innerSlots = new ArrayList();
        int i = 0;
        while (i < 8) {
            j = 0;
            while (j < 8) {
                this.allSlots.add(new float[]{i, j});
                if (i == 0 || i == 7 || j == 0 || j == 7) {
                    this.borderSlots.add(new float[]{i, j});
                } else {
                    this.innerSlots.add(new float[]{i, j});
                }
                ++j;
            }
            ++i;
        }
        this.currentLevel = 0;
        i = 0;
        while (i < 8) {
            j = 0;
            while (j < 8) {
                this.blackTiles.add(new int[]{i, j++});
            }
            ++i;
        }
        this.blackTileTimer = 0.05f;
        this.advanceLevel();
    }

    public void update(float dt) {
        if (this.blockTime > 0.0f) {
            this.blockTime -= dt;
        }
        if (this.enemyTurnTimer > 0.0f) {
            this.enemyTurnTimer -= dt;
            if (this.enemyTurnTimer <= 0.0f) {
                if (this.projectiles.size() > 0) {
                    this.enemyTurnTimer = 0.001f;
                } else {
                    this.moveEnemies();
                }
            }
        }
        if (this.blackTileTimer > 0.0f) {
            this.blackTileTimer -= dt;
            if (this.blackTileTimer <= 0.0f) {
                int index;
                int i;
                if (this.advancingLevel) {
                    i = 0;
                    while (i < 8) {
                        if (this.nonBlackTiles.size() > 0) {
                            index = (int)Math.floor(Math.random() * (double)this.nonBlackTiles.size());
                            this.blackTiles.add(this.nonBlackTiles.get(index));
                            this.nonBlackTiles.remove(index);
                        }
                        ++i;
                    }
                    if (this.blackTiles.size() >= 64) {
                        this.advancingLevel = false;
                        this.advanceLevel();
                    }
                    if (this.currentLevel <= 6) {
                        this.blockTime = this.blackTileTimer = 0.05f;
                    }
                } else {
                    i = 0;
                    while (i < 8) {
                        index = (int)Math.floor(Math.random() * (double)this.blackTiles.size());
                        this.blackTiles.remove(index);
                        ++i;
                    }
                    if (this.blackTiles.size() > 0) {
                        this.blockTime = this.blackTileTimer = 0.05f;
                    }
                }
            }
        }
        this.hero.update(dt);
        Element elem = null;
        elem = this.hero.dashing || this.hero.quickIndex > 0 ? this.getElementAt((float)Math.floor(this.hero.getPosition()[0]), (float)Math.floor(this.hero.getPosition()[1])) : this.getElementAt(this.hero.getSlot()[0], this.hero.getSlot()[1]);
        if (elem != null && elem.type == Element.ElementType.kTypeGem) {
            this.statics.remove(elem);
            this.gemCatched(((Collectable)elem).tileType);
            this.ownedGems.add((Collectable)elem);
        }
        ArrayList<Object> toRemove = new ArrayList<Object>();
        for (Unit unit : this.units) {
            unit.update(dt);
            if (this.hero.dashing && Point.distance(unit.getSlot()[0], unit.getSlot()[1], this.hero.getPosition()[0], this.hero.getPosition()[1]) < 0.5) {
                unit.takeHit();
            }
            if (!unit.shouldRemove()) continue;
            ++this.hero.killScore;
            toRemove.add(unit);
        }
        for (Unit unit : toRemove) {
            this.units.remove(unit);
        }
        for (Projectile projectile : this.projectiles) {
            projectile.update(dt);
            if (projectile.shouldRemove()) {
                toRemove.add(projectile);
                continue;
            }
            if (!projectile.isActive()) continue;
            if (!projectile.isFriendly()) {
                this.blockTime = 0.05f;
            }
            for (Element e : this.statics) {
                if (e.type != Element.ElementType.kTypeWall || !(Point.distance(e.getSlot()[0], e.getSlot()[1], projectile.getPosition()[0], projectile.getPosition()[1]) < 0.5)) continue;
                projectile.fadeOut(false);
            }
            if (!this.isValidSlot(projectile.getPosition()[0], projectile.getPosition()[1])) {
                projectile.fadeOut(false);
                continue;
            }
            if (projectile.isFriendly()) {
                for (Unit u : this.units) {
                    if (!(Point.distance(u.getSlot()[0], u.getSlot()[1], projectile.getPosition()[0], projectile.getPosition()[1]) < 0.5)) continue;
                    u.takeHit();
                    projectile.fadeOut(true);
                }
                continue;
            }
            if (!(Point.distance(this.hero.getSlot()[0], this.hero.getSlot()[1], projectile.getPosition()[0], projectile.getPosition()[1]) < 0.5)) continue;
            this.hitHero(projectile.getDirection());
            projectile.fadeOut(true);
        }
        for (DSprite dSprite : toRemove) {
            this.projectiles.remove(dSprite);
        }
        for (MagicTile magicTile : this.tiles) {
            magicTile.update(dt);
            if (!magicTile.shouldRemove()) continue;
            toRemove.add(magicTile);
        }
        for (Object object : toRemove) {
            this.tiles.remove(object);
        }
    }

    public void castSpell() {
        if (this.blockTime > 0.0f) {
            return;
        }
        MagicTile t = this.getTileAt(this.hero.getSlot()[0], this.hero.getSlot()[1]);
        if (t == null || t.getType() == MagicTile.TileType.Used) {
            return;
        }
        this.tiles.remove(t);
        this.tiles.add(new MagicTile(MagicTile.TileType.Used, t.getSlot(), false));
        System.out.println("Tile = " + (Object)((Object)t.getType()));
        boolean shouldPassTurn = true;
        float blockTime = 0.25f;
        switch (t.getType()) {
            case Fireball: {
                this.hero.willThrow = !this.hero.willThrow;
                blockTime = 0.0f;
                shouldPassTurn = false;
                break;
            }
            case OffensiveStance: {
                this.hero.castOffensiveStance();
                shouldPassTurn = false;
                break;
            }
            case Lightning: {
                this.castLightning();
                blockTime = 0.4f;
                break;
            }
            case DefensiveStance: {
                this.hero.castDefensiveStance();
                shouldPassTurn = false;
                break;
            }
            case Shield: {
                shouldPassTurn = false;
                if (this.hero.shield) break;
                this.hero.shield = true;
                break;
            }
            case Teleport: {
                this.castTeleport();
                break;
            }
            case QuickStance: {
                this.hero.castQuickStance();
                shouldPassTurn = false;
                break;
            }
            case Freeze: {
                this.castFreeze();
                shouldPassTurn = false;
                break;
            }
            case Dash: {
                this.hero.willDash = !this.hero.willDash;
                blockTime = 0.0f;
                shouldPassTurn = false;
                break;
            }
        }
        if (shouldPassTurn) {
            this.blockTime = blockTime;
            this.enemyTurnTimer = blockTime - 0.1f;
        }
    }

    public void moveHero(int dir) {
        if (this.blockTime > 0.0f) {
            return;
        }
        if (this.hero.willThrow) {
            this.castFireball(dir);
            this.hero.willThrow = false;
        } else if (this.hero.willDash) {
            this.castDash(dir);
            if (this.hero.dashing) {
                this.hero.willDash = false;
            }
        } else if (this.hero.offensiveIndex > 0 && this.enemyInFront(dir) != null) {
            this.hero.setDirection(dir);
            this.hero.consumeCharge();
            this.hero.tackle(dir);
            this.enemyInFront(dir).takeHit();
            this.enemyTurnTimer = 0.16f;
            this.blockTime = this.enemyTurnTimer + 0.16f;
        } else {
            Element e;
            boolean canMove = true;
            float nextPosX = this.hero.getSlot()[0];
            float nextPosY = this.hero.getSlot()[1];
            float[] d = Global.getVectorFromDir(dir);
            if (!this.isValidSlot(nextPosX += d[0], nextPosY += d[1])) {
                canMove = false;
            }
            if ((e = this.getElementAt(nextPosX, nextPosY)) != null && e.getType() != Element.ElementType.kTypeGem) {
                if (e.type == Element.ElementType.kTypeWall) {
                    canMove = false;
                } else if (!this.canPushRow(e.getSlot(), dir)) {
                    canMove = false;
                }
            }
            if (canMove) {
                this.hero.setDashing(false);
                this.elementMoving(this.hero.getSlot(), new float[]{nextPosX, nextPosY});
                this.hero.moveTo(nextPosX, nextPosY);
                if (this.hero.quickIndex > 0) {
                    if (this.hero.stamina > 1) {
                        --this.hero.stamina;
                        this.hero.consumeCharge();
                        this.moveHero(dir);
                        this.enemyTurnTimer = 0.15f;
                        this.blockTime = 0.25f;
                    } else {
                        this.hero.stamina = 2;
                    }
                } else {
                    this.enemyTurnTimer = 0.15f;
                    this.blockTime = 0.25f;
                }
            } else {
                if (dir == 1 && this.hero.getSlot()[0] == this.portal.getSlot()[0] && this.hero.getSlot()[1] == this.portal.getSlot()[1]) {
                    this.setupBlackTiles();
                    this.advancingLevel = true;
                    this.blackTileTimer = 0.05f;
                    return;
                }
                if (this.hero.quickIndex > 0) {
                    this.hero.stamina = 2;
                }
            }
        }
    }

    private void moveEnemies() {
        for (Unit e : this.units) {
            ((Enemy)e).move();
        }
    }

    private void gemCatched(MagicTile.TileType type) {
        SoundManager.getSharedManager().playSound("pick up.wav");
        if (this.ownedGems.size() == 0) {
            int i = 0;
            while (i < 16) {
                this.tiles.add(new MagicTile(type, this.getRandomEmptySlot(), true));
                ++i;
            }
        } else {
            ArrayList<MagicTile> removed = new ArrayList<MagicTile>();
            int nReplace = (int)Math.ceil(16 / (this.ownedGems.size() + 1));
            int i = 0;
            while (i < nReplace) {
                int index = (int)Math.floor(Math.random() * (double)this.tiles.size());
                removed.add(this.tiles.get(index));
                this.tiles.get(index).startRemoval();
                this.tiles.remove(index);
                ++i;
            }
            for (MagicTile t : removed) {
                this.tiles.add(t);
                this.tiles.add(new MagicTile(type, t.getSlot(), true));
            }
        }
    }

    private void castFireball(int nDir) {
        Projectile fireball = new Projectile(nDir, Projectile.ProjectileType.Fireball, true);
        fireball.setPosition(this.hero.getPosition());
        this.projectiles.add(fireball);
        this.hero.setDirection(nDir);
        float[] dir = Global.getVectorFromDir(nDir);
        boolean elemFound = false;
        boolean boundsReached = false;
        int i = 0;
        do {
            float[] nextPos;
            Element e;
            elemFound = (e = this.getElementAt((nextPos = new float[]{this.hero.getSlot()[0] + (float)(++i) * dir[0], this.hero.getSlot()[1] + (float)i * dir[1]})[0], nextPos[1])) != null && (e.type == Element.ElementType.kTypeWall || e.type == Element.ElementType.kTypeEnemy);
            boolean bl = boundsReached = !this.isValidSlot(nextPos[0], nextPos[1]);
        } while (!elemFound && !boundsReached);
        this.enemyTurnTimer = (float)i * 0.083f;
        this.blockTime = this.enemyTurnTimer + 0.16f;
        SoundManager.getSharedManager().playSound("fire throw.wav");
    }

    private void castLightning() {
        int i = 0;
        while (i < 4) {
            float[] dir = Global.getVectorFromDir(i);
            float[] pos = new float[]{this.hero.getPosition()[0] + dir[0], this.hero.getPosition()[1] + dir[1]};
            if (this.isValidSlot(pos[0], pos[1])) {
                Projectile light = new Projectile(-1, Projectile.ProjectileType.Lightning, true);
                light.setPosition(pos);
                this.projectiles.add(light);
            }
            float[] nextDir = Global.getVectorFromDir((i + 1) % 4);
            pos = new float[]{this.hero.getPosition()[0] + dir[0] + nextDir[0], this.hero.getPosition()[1] + dir[1] + nextDir[1]};
            if (this.isValidSlot(pos[0], pos[1])) {
                Projectile light = new Projectile(-1, Projectile.ProjectileType.Lightning, true);
                light.setPosition(pos);
                this.projectiles.add(light);
            }
            ++i;
        }
        SoundManager.getSharedManager().playSound("spark.wav");
    }

    private void castTeleport() {
        ArrayList<MagicTile> tpTiles = new ArrayList<MagicTile>();
        for (MagicTile t : this.tiles) {
            if (t.getType() != MagicTile.TileType.Teleport || this.hero.getSlot()[0] == t.getSlot()[0] && this.hero.getSlot()[1] == t.getSlot()[1] || this.getElementAt(t.getSlot()[0], t.getSlot()[1]) != null) continue;
            tpTiles.add(t);
        }
        if (tpTiles.size() > 0) {
            SoundManager.getSharedManager().playSound("swap.wav");
            float[] pos = ((MagicTile)tpTiles.get((int)Math.floor(Math.random() * (double)tpTiles.size()))).getSlot();
            this.hero.teleportTo(pos);
        }
    }

    private void castFreeze() {
        for (Unit u : this.units) {
            u.stun();
        }
    }

    private void castDash(int nDir) {
        float[] dir = Global.getVectorFromDir(nDir);
        boolean wallFound = false;
        boolean boundsReached = false;
        int i = 0;
        do {
            float[] nextPos;
            Element e;
            wallFound = (e = this.getElementAt((nextPos = new float[]{this.hero.getSlot()[0] + (float)(++i) * dir[0], this.hero.getSlot()[1] + (float)i * dir[1]})[0], nextPos[1])) != null && e.type == Element.ElementType.kTypeWall;
            boolean bl = boundsReached = !this.isValidSlot(nextPos[0], nextPos[1]);
        } while (!wallFound && !boundsReached);
        if (i > 1) {
            SoundManager.getSharedManager().playSound("dash.wav");
            this.hero.setNextPos(this.hero.getSlot()[0] + (float)(i - 1) * dir[0], this.hero.getSlot()[1] + (float)(i - 1) * dir[1]);
            this.hero.setDirection(nDir);
            this.hero.setDashing(true);
            this.enemyTurnTimer = Math.max(0.085f * (float)(i - 1), 0.2f);
            this.blockTime = this.enemyTurnTimer + 0.18f;
        }
    }

    private void advanceLevel() {
        Element e;
        ++this.currentLevel;
        if (this.currentLevel > 6) {
            return;
        }
        this.projectiles.clear();
        this.statics.clear();
        this.units.clear();
        this.tiles.clear();
        this.randomizeHeroAndPortal();
        Map<String, Integer> level = WaveManager.getSharedManager().getLevel(this.currentLevel - 1);
        int n = level.get("objElementWall");
        int i = 0;
        while (i < n) {
            e = new Wall();
            this.statics.add(e);
            do {
                e.setPosition(this.getRandomEmptyInnerSlot());
            } while (!this.isMapConnected());
            ++i;
        }
        n = level.get("objEnemy1");
        i = 0;
        while (i < n) {
            e = new EnemyBasic(this);
            if (this.currentLevel > 1) {
                ((Unit)e).teleportTo(this.getRandomEmptySlotForEnemy());
            } else {
                ArrayList<float[]> slotSet = new ArrayList<float[]>();
                int k = 0;
                while (k < 8) {
                    slotSet.add(new float[]{7.0f, k});
                    ++k;
                }
                ((Unit)e).teleportTo(this.getRandomEmptySlot(slotSet));
            }
            this.units.add((Unit)e);
            ++i;
        }
        n = level.get("objEnemy2");
        i = 0;
        while (i < n) {
            e = new EnemyQuick(this);
            ((Unit)e).teleportTo(this.getRandomEmptySlotForEnemy());
            this.units.add((Unit)e);
            ++i;
        }
        n = level.get("objEnemy3");
        i = 0;
        while (i < n) {
            e = new EnemyRanged(this);
            ((Unit)e).teleportTo(this.getRandomEmptySlotForEnemy());
            this.units.add((Unit)e);
            ++i;
        }
        int nTiles = 0;
        int i2 = 0;
        while (i2 < this.ownedGems.size()) {
            n = (int)Math.ceil((16 - nTiles) / (this.ownedGems.size() - i2));
            int j = 0;
            while (j < n) {
                this.tiles.add(new MagicTile(this.ownedGems.get((int)i2).tileType, this.getRandomEmptySlot(), false));
                ++j;
            }
            nTiles += n;
            ++i2;
        }
        n = level.get("objGemFireball");
        if (n > 0) {
            Collectable c = new Collectable(MagicTile.TileType.Fireball);
            c.setPosition(this.getRandomEmptyBorderSlot());
            this.statics.add(c);
        }
        if ((n = level.get("objGemOffensiveStance").intValue()) > 0) {
            Collectable c = new Collectable(MagicTile.TileType.OffensiveStance);
            c.setPosition(this.getRandomEmptyBorderSlot());
            this.statics.add(c);
        }
        if ((n = level.get("objGemLightning").intValue()) > 0) {
            Collectable c = new Collectable(MagicTile.TileType.Lightning);
            c.setPosition(this.getRandomEmptyBorderSlot());
            this.statics.add(c);
        }
        if ((n = level.get("objGemDefensiveStance").intValue()) > 0) {
            Collectable c = new Collectable(MagicTile.TileType.DefensiveStance);
            c.setPosition(this.getRandomEmptyBorderSlot());
            this.statics.add(c);
        }
        if ((n = level.get("objGemShield").intValue()) > 0) {
            Collectable c = new Collectable(MagicTile.TileType.Shield);
            c.setPosition(this.getRandomEmptyBorderSlot());
            this.statics.add(c);
        }
        if ((n = level.get("objGemTeleport").intValue()) > 0) {
            Collectable c = new Collectable(MagicTile.TileType.Teleport);
            c.setPosition(this.getRandomEmptyBorderSlot());
            this.statics.add(c);
        }
        if ((n = level.get("objGemQuickStance").intValue()) > 0) {
            Collectable c = new Collectable(MagicTile.TileType.QuickStance);
            c.setPosition(this.getRandomEmptyBorderSlot());
            this.statics.add(c);
        }
        if ((n = level.get("objGemFreeze").intValue()) > 0) {
            Collectable c = new Collectable(MagicTile.TileType.Freeze);
            c.setPosition(this.getRandomEmptyBorderSlot());
            this.statics.add(c);
        }
        if ((n = level.get("objGemDash").intValue()) > 0) {
            Collectable c = new Collectable(MagicTile.TileType.Dash);
            c.setPosition(this.getRandomEmptyBorderSlot());
            this.statics.add(c);
        }
    }

    private void randomizeHeroAndPortal() {
        this.hero.teleportTo(new float[]{0.0f, (float)Math.floor(Math.random() * 8.0)});
        this.hero.setDirection(2);
        ++this.hero.lives;
        this.hero.shield = false;
        this.hero.consumeAllCharges();
        if (this.hero.quickIndex > 0) {
            this.hero.stamina = 2;
        }
        this.portal.setPosition(new float[]{7.0f, 1.0f + (float)Math.floor(Math.random() * 6.0)});
    }

    private float[] getRandomEmptySlot(ArrayList<float[]> slotSet) {
        ArrayList allSlots = (ArrayList)slotSet.clone();
        ArrayList<float[]> toRemove = new ArrayList<float[]>();
        for (float[] slot : allSlots) {
            if (this.getElementAt(slot[0], slot[1]) != null) {
                toRemove.add(slot);
            } else if (this.hero.getSlot()[0] == slot[0] && this.hero.getSlot()[1] == slot[1]) {
                toRemove.add(slot);
            }
            if (this.getTileAt(slot[0], slot[1]) != null) {
                toRemove.add(slot);
            }
            if (this.portal.getSlot()[0] != slot[0] || this.portal.getSlot()[1] != slot[1]) continue;
            toRemove.add(slot);
        }
        for (float[] slot : toRemove) {
            allSlots.remove(slot);
        }
        return (float[])allSlots.get((int)Math.floor(Math.random() * (double)allSlots.size()));
    }

    private float[] getRandomEmptySlot() {
        return this.getRandomEmptySlot(this.allSlots);
    }

    private float[] getRandomEmptySlotForEnemy() {
        ArrayList<float[]> slots = new ArrayList<float[]>();
        System.out.println("#all slots = " + this.allSlots.size());
        for (float[] p : this.allSlots) {
            if (!(Math.abs(this.hero.getSlot()[0] - p[0]) > 3.5f) && !(Math.abs(this.hero.getSlot()[1] - p[1]) > 3.5f)) continue;
            slots.add(new float[]{p[0], p[1]});
        }
        System.out.println("#enem slots = " + slots.size());
        return this.getRandomEmptySlot(slots);
    }

    private float[] getRandomEmptyBorderSlot() {
        return this.getRandomEmptySlot(this.borderSlots);
    }

    private float[] getRandomEmptyInnerSlot() {
        return this.getRandomEmptySlot(this.innerSlots);
    }

    @Override
    public Element getElementAt(float x, float y) {
        for (Element element : this.units) {
            if (element.getSlot()[0] != x || element.getSlot()[1] != y) continue;
            return element;
        }
        for (Element element : this.statics) {
            if (element.getSlot()[0] != x || element.getSlot()[1] != y) continue;
            return element;
        }
        return null;
    }

    private boolean isValidSlot(float x, float y) {
        return x >= 0.0f && x <= 7.0f && y >= 0.0f && y <= 7.0f;
    }

    private boolean canPushRow(float[] fromPos, int nDir) {
        float[] dir = Global.getVectorFromDir(nDir);
        fromPos[0] = fromPos[0] + dir[0];
        fromPos[1] = fromPos[1] + dir[1];
        boolean elementFound = false;
        while (fromPos[0] >= 0.0f && fromPos[0] < 8.0f && fromPos[1] >= 0.0f && fromPos[1] < 8.0f) {
            elementFound = false;
            for (Unit unit : this.units) {
                if (unit.getSlot()[0] != fromPos[0] || unit.getSlot()[1] != fromPos[1]) continue;
                elementFound = true;
            }
            for (Element element : this.statics) {
                if (element.getSlot()[0] != fromPos[0] || element.getSlot()[1] != fromPos[1]) continue;
                if (element.getType() == Element.ElementType.kTypeWall) {
                    return false;
                }
                if (element.getType() == Element.ElementType.kTypeGem) continue;
                elementFound = true;
            }
            if (this.hero.getSlot()[0] == fromPos[0] && this.hero.getSlot()[1] == fromPos[1]) {
                elementFound = true;
            }
            if (!elementFound) {
                return true;
            }
            fromPos[0] = fromPos[0] + dir[0];
            fromPos[1] = fromPos[1] + dir[1];
        }
        return false;
    }

    private MagicTile getTileAt(float x, float y) {
        for (MagicTile t : this.tiles) {
            if (t.getSlot()[0] != x || t.getSlot()[1] != y) continue;
            return t;
        }
        return null;
    }

    private void setupBlackTiles() {
        int i = 0;
        while (i < 8) {
            int j = 0;
            while (j < 8) {
                this.nonBlackTiles.add(new int[]{i, j++});
            }
            ++i;
        }
    }

    private Enemy enemyInFront(int nDir) {
        float[] dir = Global.getVectorFromDir(nDir);
        float[] nextPos = new float[]{this.hero.getSlot()[0] + dir[0], this.hero.getSlot()[1] + dir[1]};
        Element e = this.getElementAt(nextPos[0], nextPos[1]);
        if (e != null && e.type == Element.ElementType.kTypeEnemy) {
            return (Enemy)e;
        }
        return null;
    }

    private boolean isMapConnected() {
        ArrayList<int[]> openNodes = new ArrayList<int[]>();
        openNodes.add(new int[]{(int)this.hero.getSlot()[0], (int)this.hero.getSlot()[1]});
        ArrayList<int[]> toAdd = new ArrayList<int[]>();
        boolean[][] map = new boolean[8][8];
        int i = 0;
        while (i < 8) {
            int j = 0;
            while (j < 8) {
                map[i][j] = false;
                ++j;
            }
            ++i;
        }
        while (openNodes.size() > 0) {
            for (int[] p : openNodes) {
                map[p[0]][p[1]] = true;
                int i2 = p[0];
                int j = p[1] + 1;
                Element elem = this.getElementAt(i2, j);
                if (j < 8 && !map[i2][j] && elem == null) {
                    toAdd.add(new int[]{i2, j});
                }
                i2 = p[0];
                j = p[1] - 1;
                elem = this.getElementAt(i2, j);
                if (j >= 0 && !map[i2][j] && elem == null) {
                    toAdd.add(new int[]{i2, j});
                }
                i2 = p[0] + 1;
                j = p[1];
                elem = this.getElementAt(i2, j);
                if (i2 < 8 && !map[i2][j] && elem == null) {
                    toAdd.add(new int[]{i2, j});
                }
                i2 = p[0] - 1;
                j = p[1];
                elem = this.getElementAt(i2, j);
                if (i2 < 0 || map[i2][j] || elem != null) continue;
                toAdd.add(new int[]{i2, j});
            }
            openNodes.clear();
            for (int[] p : toAdd) {
                openNodes.add(p);
            }
            toAdd.clear();
        }
        int i3 = 0;
        while (i3 < 8) {
            int j = 0;
            while (j < 8) {
                Element elem = this.getElementAt(i3, j);
                if (!(map[i3][j] || elem != null && elem.type == Element.ElementType.kTypeWall)) {
                    return false;
                }
                ++j;
            }
            ++i3;
        }
        return true;
    }

    public String getDescriptionAt(float x, float y) {
        MagicTile t = this.getTileAt(x, y);
        if (t != null) {
            return t.getDescription();
        }
        Element e = this.getElementAt(x, y);
        if (e != null && e.type == Element.ElementType.kTypeGem) {
            return e.getDescription();
        }
        if (this.portal.getSlot()[0] == x && this.portal.getSlot()[1] == y) {
            return "Go to next room";
        }
        return null;
    }

    public ArrayList<DSprite> getSprites() {
        ArrayList<DSprite> sprites = new ArrayList<DSprite>();
        sprites.add(this.portal);
        sprites.addAll(this.statics);
        sprites.addAll(this.units);
        sprites.add(this.hero);
        sprites.addAll(this.projectiles);
        return sprites;
    }

    public ArrayList<MagicTile> getTiles() {
        return this.tiles;
    }

    public ArrayList<Collectable> getOwnedGems() {
        return this.ownedGems;
    }

    public ArrayList<int[]> getBlackTiles() {
        return this.blackTiles;
    }

    public int getLevel() {
        return this.currentLevel;
    }

    @Override
    public Hero getHero() {
        return this.hero;
    }

    @Override
    public boolean isSlotAvailable(float x, float y) {
        Element e = this.getElementAt(x, y);
        return e == null || e.type != Element.ElementType.kTypeWall && e.type != Element.ElementType.kTypeEnemy;
    }

    @Override
    public void elementMoving(float[] fromPos, float[] toPos) {
        float[] dir = new float[]{toPos[0] - fromPos[0], toPos[1] - fromPos[1]};
        for (Unit e : this.units) {
            if (e.getSlot()[0] != toPos[0] || e.getSlot()[1] != toPos[1]) continue;
            float[] prev = e.getSlot();
            float[] next = new float[]{prev[0] + dir[0], prev[1] + dir[1]};
            this.elementMoving(prev, next);
            e.moveTo(next);
        }
    }

    @Override
    public void hitHero(int dir) {
        if (this.hero.defensiveIndex > 0) {
            this.hero.consumeCharge();
            return;
        }
        if (this.hero.shield) {
            this.hero.shield = false;
        } else {
            this.hero.lives = Math.max(0, this.hero.lives - 1);
        }
        SoundManager.getSharedManager().playSound("hit.wav");
    }

    @Override
    public void addProjectile(Projectile p) {
        this.projectiles.add(p);
    }
}

