/*
 * Decompiled with CFR 0.152.
 */
package roguelike;

import roguelike.ColorManager;
import roguelike.DSprite;
import roguelike.Global;
import roguelike.SoundManager;

public class Projectile
extends DSprite {
    private float[] direction;
    private boolean friendly;
    private ProjectileType type;
    private float fadeTimer;

    public Projectile(int dir, ProjectileType type, boolean friendly) {
        this.direction = Global.getVectorFromDir(dir);
        this.friendly = friendly;
        this.type = type;
        this.fadeTimer = -1.0f;
        String name = "";
        switch (type) {
            case Fireball: {
                name = "Fireball";
                break;
            }
            case Arrow: {
                name = "Arrow";
                break;
            }
            case Lightning: {
                name = "Lightning";
                this.fadeTimer = 0.0f;
                break;
            }
        }
        this.colorModel = dir >= 0 ? ColorManager.getSharedManager().getColorModel(String.valueOf(name) + dir) : ColorManager.getSharedManager().getColorModel(name);
    }

    public void update(float dt) {
        this.positionX += 12.0f * this.direction[0] * dt;
        this.positionY += 12.0f * this.direction[1] * dt;
        if (this.fadeTimer >= 0.0f) {
            this.fadeTimer += dt;
        }
    }

    public boolean isActive() {
        return this.fadeTimer < 0.0f || this.type == ProjectileType.Lightning;
    }

    public void fadeOut(boolean didHit) {
        if (this.fadeTimer >= 0.0f) {
            return;
        }
        this.direction[0] = 0.0f;
        this.direction[1] = 0.0f;
        this.fadeTimer = 0.0f;
        if (didHit) {
            String name = "";
            switch (this.type) {
                case Fireball: {
                    name = "fire burn.wav";
                    break;
                }
                case Arrow: {
                    break;
                }
            }
            SoundManager.getSharedManager().playSound(name);
        }
    }

    public boolean shouldRemove() {
        return this.fadeTimer > 0.15f;
    }

    public boolean isFriendly() {
        return this.friendly;
    }

    public int getDirection() {
        return Global.getIntFromDir(this.direction);
    }

    public static enum ProjectileType {
        Fireball,
        Arrow,
        Lightning;

    }
}

