/*
 * Decompiled with CFR 0.152.
 */
package roguelike;

import java.awt.Color;
import java.util.ArrayList;
import roguelike.ColorManager;
import roguelike.Element;
import roguelike.Global;
import roguelike.MagicTile;
import roguelike.MapManager;
import roguelike.Unit;

public class Enemy
extends Unit {
    protected MapManager map;
    protected String name;

    public Enemy(MapManager map) {
        super(Element.ElementType.kTypeEnemy);
        this.map = map;
    }

    public void move() {
        if (this.stunCount > 0) {
            this.updateCooldowns();
            return;
        }
        int[] dir = this.getOptimalDirection(MovePriority.GetCloser);
        float[] nextPos = new float[]{this.nextPosX + (float)dir[0], this.nextPosY + (float)dir[1]};
        if (this.map.getHero().getSlot()[0] == nextPos[0] && this.map.getHero().getSlot()[1] == nextPos[1]) {
            this.map.hitHero(Global.getIntFromDir(new float[]{dir[0], dir[1]}));
            this.tackleDestination = new float[]{this.getSlot()[0] + (float)dir[0], this.getSlot()[1] + (float)dir[1]};
        } else if (dir[0] != 0 || dir[1] != 0) {
            this.map.elementMoving(this.getSlot(), nextPos);
            super.moveTo(nextPos);
        }
    }

    protected void updateCooldowns() {
        --this.stunCount;
        if (this.stunCount > 0) {
            Color freezeColor = MagicTile.getColorByType(MagicTile.TileType.Freeze);
            int k = 0;
            while (k < 6 - this.stunCount) {
                freezeColor = freezeColor.darker();
                ++k;
            }
            this.colorModel = ColorManager.getSharedManager().getColorModel(this.name, freezeColor);
        } else {
            this.colorModel = ColorManager.getSharedManager().getColorModel(this.name);
        }
    }

    protected int[] getOptimalDirection(MovePriority priority) {
        int[] deltaPos;
        int max;
        int w = 8;
        int h = 8;
        int x_i = (int)this.map.getHero().getSlot()[0];
        int y_i = (int)this.map.getHero().getSlot()[1];
        int x_f = (int)this.getSlot()[0];
        int y_f = (int)this.getSlot()[1];
        int[] current = new int[]{x_i, y_i};
        int x = current[0];
        int y = current[1];
        int[][] costos = new int[w][h];
        NodeStatus[][] status = new NodeStatus[w][h];
        int i = 0;
        while (i < w) {
            int j = 0;
            while (j < h) {
                status[i][j] = NodeStatus.Unvisited;
                costos[i][j] = 2 * w * h;
                ++j;
            }
            ++i;
        }
        ArrayList<int[]> abiertos = new ArrayList<int[]>();
        abiertos.add(new int[]{x, y});
        costos[x][y] = 0;
        while ((x != x_f || y != y_f) && abiertos.size() > 0) {
            status[current[0]][current[1]] = NodeStatus.Closed;
            int i2 = 0;
            while (i2 < abiertos.size()) {
                if (((int[])abiertos.get(i2))[0] == x && ((int[])abiertos.get(i2))[1] == y) {
                    abiertos.remove(i2);
                    break;
                }
                ++i2;
            }
            if (x > 0 && (this.map.isSlotAvailable(x - 1, y) || x - 1 == x_f && y == y_f) && status[x - 1][y] != NodeStatus.Closed) {
                status[x - 1][y] = NodeStatus.Opened;
                abiertos.add(new int[]{x - 1, y});
                costos[x - 1][y] = costos[x][y] + 1;
            }
            if (x + 1 < w && (this.map.isSlotAvailable(x + 1, y) || x + 1 == x_f && y == y_f) && status[x + 1][y] != NodeStatus.Closed) {
                status[x + 1][y] = NodeStatus.Opened;
                abiertos.add(new int[]{x + 1, y});
                costos[x + 1][y] = costos[x][y] + 1;
            }
            if (y > 0 && (this.map.isSlotAvailable(x, y - 1) || y - 1 == y_f && x == x_f) && status[x][y - 1] != NodeStatus.Closed) {
                status[x][y - 1] = NodeStatus.Opened;
                abiertos.add(new int[]{x, y - 1});
                costos[x][y - 1] = costos[x][y] + 1;
            }
            if (y + 1 < h && (this.map.isSlotAvailable(x, y + 1) || y + 1 == y_f && x == x_f) && status[x][y + 1] != NodeStatus.Closed) {
                status[x][y + 1] = NodeStatus.Opened;
                abiertos.add(new int[]{x, y + 1});
                costos[x][y + 1] = costos[x][y] + 1;
            }
            int min = Integer.MAX_VALUE;
            int i3 = 0;
            while (i3 < abiertos.size()) {
                int[] temp = (int[])abiertos.get(i3);
                if (costos[temp[0]][temp[1]] < min) {
                    min = costos[temp[0]][temp[1]];
                    current = temp;
                }
                ++i3;
            }
            x = current[0];
            y = current[1];
        }
        int[] a = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE};
        if (x_f > 0 && this.map.isSlotAvailable(x_f - 1, y_f)) {
            a[0] = costos[x_f - 1][y_f];
        }
        if (x_f + 1 < w && this.map.isSlotAvailable(x_f + 1, y_f)) {
            a[1] = costos[x_f + 1][y_f];
        }
        if (y_f > 0 && this.map.isSlotAvailable(x_f, y_f - 1)) {
            a[2] = costos[x_f][y_f - 1];
        }
        if (y_f + 1 < h && this.map.isSlotAvailable(x_f, y_f + 1)) {
            a[3] = costos[x_f][y_f + 1];
        }
        if (a[0] > (max = 2 * w * h) && a[1] > max && a[2] > max && a[3] > max) {
            return new int[2];
        }
        int min = 2 * max;
        int index = -1;
        if (priority == MovePriority.GetCloser) {
            if (Math.abs(x_f - x_i) >= Math.abs(y_f - y_i)) {
                int i4 = 0;
                while (i4 < 4) {
                    if (a[i4] < min) {
                        min = a[i4];
                        index = i4;
                    }
                    ++i4;
                }
            } else {
                int i5 = 3;
                while (i5 >= 0) {
                    if (a[i5] < min) {
                        min = a[i5];
                        index = i5;
                    }
                    --i5;
                }
            }
        } else if (Math.abs(x_f - x_i) < Math.abs(y_f - y_i)) {
            int i6 = 0;
            while (i6 < 4) {
                if (a[i6] < min) {
                    min = a[i6];
                    index = i6;
                }
                ++i6;
            }
        } else {
            int i7 = 3;
            while (i7 >= 0) {
                if (a[i7] < min) {
                    min = a[i7];
                    index = i7;
                }
                --i7;
            }
        }
        if (index == 0) {
            int[] nArray = new int[2];
            nArray[0] = -1;
            deltaPos = nArray;
        } else if (index == 1) {
            int[] nArray = new int[2];
            nArray[0] = 1;
            deltaPos = nArray;
        } else if (index == 2) {
            int[] nArray = new int[2];
            nArray[1] = -1;
            deltaPos = nArray;
        } else {
            int[] nArray = new int[2];
            nArray[1] = 1;
            deltaPos = nArray;
        }
        return deltaPos;
    }

    @Override
    public void stun() {
        super.stun();
        Color freezeColor = MagicTile.getColorByType(MagicTile.TileType.Freeze);
        int k = 0;
        while (k < 6 - this.stunCount) {
            freezeColor = freezeColor.darker();
            ++k;
        }
        this.colorModel = ColorManager.getSharedManager().getColorModel(this.name, freezeColor);
    }

    public static enum MovePriority {
        GetCloser,
        GetAlligned;

    }

    public static enum NodeStatus {
        Opened,
        Closed,
        Unvisited;

    }
}

