/*
 * Decompiled with CFR 0.152.
 */
package roguelike;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import roguelike.Collectable;
import roguelike.ColorManager;
import roguelike.DSprite;
import roguelike.GameModel;
import roguelike.MagicTile;
import roguelike.SoundManager;

public class Board
extends JPanel
implements ActionListener,
KeyListener,
MouseMotionListener {
    private final int DELAY = 50;
    private GameModel model;
    private GameState state;
    private Timer timer;
    private boolean isFullscreen;
    private int mouseX;
    private int mouseY;
    private final String title = "POWER GROUNDS";
    private float colorTimer;
    private int coloredLetter;
    private Color randColor;
    private boolean sweepingTitle;

    public Board() {
        this.setBackground(Color.black);
        this.addKeyListener(this);
        this.addMouseMotionListener(this);
        this.setFocusable(true);
        this.requestFocusInWindow();
        SoundManager.getSharedManager().preloadSounds();
        this.state = GameState.WaitingForStart;
        if (this.timer != null) {
            this.timer.stop();
        }
        this.timer = new Timer(50, this);
        this.timer.start();
    }

    private void initGame() {
        this.state = GameState.Playing;
        this.model = new GameModel();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.doDrawing(g);
    }

    private void doDrawing(Graphics g) {
        if (this.state == GameState.WaitingForStart) {
            int blockDimX = (this.getSize().width - 10) / 30;
            int blockDimY = (this.getSize().height - 18) / 15;
            int blockDim = Math.min(blockDimX, blockDimY);
            blockDim = (int)Math.floor((double)blockDim / 5.0) * 5;
            int titleDim = (int)((double)blockDim * 1.7 / 5.0) * 5;
            this.drawString(g, "POWER GROUNDS", blockDim, 2 * blockDim, titleDim);
            if (this.coloredLetter >= 0) {
                this.drawString(g, String.valueOf("POWER GROUNDS".charAt(this.coloredLetter)), (int)((float)blockDim + (float)(this.coloredLetter * titleDim) * 1.2f), 2 * blockDim, titleDim, this.randColor);
            }
            this.drawString(g, "* Arrows or wasd to move.", blockDim, this.getSize().height / 2 - 3 * blockDim, blockDim);
            this.drawString(g, "* Space to cast spell.", blockDim, this.getSize().height / 2 - blockDim, blockDim);
            this.drawString(g, "* Mouse over for info.", blockDim, this.getSize().height / 2 + blockDim, blockDim);
            this.drawString(g, "* Press enter to start.", blockDim, this.getSize().height / 2 + 3 * blockDim, blockDim);
            this.drawString(g, "by diego cathalifaud", blockDim, this.getSize().height - 2 * blockDim, blockDim);
        } else if (this.state == GameState.Playing) {
            int charges;
            int blockDimX = (this.getSize().width - 10) / 8;
            int blockDimY = (this.getSize().height - 18) / 11;
            int blockDim = Math.min(blockDimX, blockDimY);
            blockDim = (int)Math.floor((double)blockDim / 8.0) * 8;
            int marginX = (this.getSize().width - 8 * blockDim) / 2;
            int marginY = (this.getSize().height - 11 * blockDim) / 2 + blockDim;
            g.translate(marginX, marginY);
            ArrayList<DSprite> sprites = this.model.getSprites();
            ArrayList<MagicTile> tiles = this.model.getTiles();
            g.setColor(new Color(255, 255, 255));
            g.fillRect(0, 0, 8 * blockDim, 8 * blockDim);
            for (MagicTile t : tiles) {
                g.setColor(t.getColor());
                if (t.getSweepIndex() >= 0) {
                    int i = 0;
                    while (i < Math.min(t.getSweepIndex(), 16 - t.getSweepIndex())) {
                        int j = 0;
                        while (j < 4) {
                            g.fillRect((int)(((double)t.getSlot()[0] + (double)i / 8.0) * (double)blockDim), (int)(((double)t.getSlot()[1] + (double)(2 * j + i % 2) / 8.0) * (double)blockDim), (int)((double)blockDim / 8.0), (int)((double)blockDim / 8.0));
                            ++j;
                        }
                        ++i;
                    }
                    int delta_index = 15 - t.getSweepIndex();
                    int i2 = 0;
                    while (i2 < t.getSweepIndex() - 7) {
                        g.fillRect((int)(((double)t.getSlot()[0] + (double)(i2 + delta_index) / 8.0) * (double)blockDim), (int)(t.getSlot()[1] * (float)blockDim), (int)((double)blockDim / 8.0), blockDim);
                        ++i2;
                    }
                    continue;
                }
                g.fillRect((int)(t.getSlot()[0] * (float)blockDim), (int)(t.getSlot()[1] * (float)blockDim), blockDim, blockDim);
            }
            g.setColor(new Color(230, 230, 230));
            int i = 0;
            while (i < 7) {
                g.drawLine(blockDim * (i + 1), 0, blockDim * (i + 1), 8 * blockDim - 1);
                ++i;
            }
            i = 0;
            while (i < 7) {
                g.drawLine(0, blockDim * (i + 1), 8 * blockDim - 1, blockDim * (i + 1));
                ++i;
            }
            for (DSprite s : sprites) {
                Color[][] colorModel = s.getColorModel();
                this.drawSprite(g, s, blockDim);
            }
            ArrayList<int[]> blackTiles = this.model.getBlackTiles();
            g.setColor(new Color(0, 0, 0));
            for (int[] t : blackTiles) {
                g.fillRect(t[0] * blockDim, t[1] * blockDim, blockDim, blockDim);
            }
            if (this.model.getHero().willDash || this.model.getHero().willThrow) {
                if (this.model.getHero().willDash) {
                    g.setColor(MagicTile.getColorByType(MagicTile.TileType.Dash));
                } else if (this.model.getHero().willThrow) {
                    g.setColor(MagicTile.getColorByType(MagicTile.TileType.Fireball));
                }
                int i3 = 1;
                while (i3 <= 3) {
                    int j = 0;
                    while (j < 64) {
                        if (Math.random() * 3.0 < 1.0) {
                            g.fillRect((int)((double)(-i3 * blockDim) / 8.0), (int)((double)(j * blockDim) / 8.0), blockDim / 8, blockDim / 8);
                        }
                        ++j;
                    }
                    ++i3;
                }
                i3 = 0;
                while (i3 < 3) {
                    int j = 0;
                    while (j < 64) {
                        if (Math.random() * 3.0 < 1.0) {
                            g.fillRect((int)((8.0 + (double)i3 / 8.0) * (double)blockDim), (int)((double)(j * blockDim) / 8.0), blockDim / 8, blockDim / 8);
                        }
                        ++j;
                    }
                    ++i3;
                }
            }
            g.translate(-marginX, -marginY);
            float x = (float)Math.floor((float)(this.mouseX - marginX) / (float)blockDim);
            float y = (float)Math.floor((float)(this.mouseY - marginY) / (float)blockDim);
            String desc = this.model.getDescriptionAt(x, y);
            if (desc != null) {
                int textSize = (int)Math.floor((double)(this.getSize().width - blockDim) / ((double)desc.length() * 1.2));
                textSize = (int)Math.min((double)textSize, 1.0 * (double)blockDim / 3.0);
                textSize = (int)Math.floor((double)textSize / 5.0) * 5;
                this.drawString(g, desc, blockDim / 2, (int)((double)marginY + (double)blockDim * 9.7 + (double)textSize / 2.0), textSize);
            }
            String s = "Room " + this.model.getLevel() + " of 6";
            int textSize = (int)Math.floor(blockDim / 2);
            textSize = (int)Math.floor((double)textSize / 5.0) * 5;
            this.drawString(g, s, marginX, textSize, textSize);
            g.translate(marginX, (int)((double)marginY + (double)blockDim * 8.3));
            int metaSize = (int)Math.floor(2 * blockDim / 3);
            metaSize = (int)Math.floor((double)metaSize / 8.0) * 8;
            float separation = 2.0f;
            if (this.model.getHero().lives + (this.model.getHero().shield ? 1 : 0) > 5) {
                separation = 1.2f;
            }
            int i4 = 0;
            while (i4 < this.model.getHero().lives) {
                DSprite heart = new DSprite(ColorManager.getSharedManager().getColorModel("Heart"));
                heart.setPosition(new float[]{separation * (float)i4, 0.0f});
                this.drawSprite(g, heart, metaSize);
                ++i4;
            }
            if (this.model.getHero().shield) {
                DSprite shield = new DSprite(ColorManager.getSharedManager().getColorModel("Shield"));
                shield.setPosition(new float[]{separation * (float)this.model.getHero().lives, 0.0f});
                this.drawSprite(g, shield, metaSize);
            }
            if ((charges = this.model.getHero().getCharges()) > 0) {
                this.drawString(g, "Charges:", 0, (int)(1.3 * (double)metaSize), (int)(2.0 * (double)metaSize / 3.0 / 5.0) * 5);
                int i5 = 0;
                while (i5 < charges) {
                    DSprite heart = new DSprite(ColorManager.getSharedManager().getColorModel("Mana"));
                    heart.setPosition(new float[]{6.0f + 1.1f * (float)i5, 1.1f});
                    this.drawSprite(g, heart, metaSize);
                    ++i5;
                }
            }
            DSprite skull = new DSprite(ColorManager.getSharedManager().getColorModel("Skull"));
            skull.setPosition(new float[]{10.5f, 0.0f});
            this.drawSprite(g, skull, metaSize);
            String kills = "" + this.model.getHero().killScore;
            textSize = (int)Math.floor((double)metaSize / 7.0) * 5;
            this.drawString(g, kills, (int)(11.7 * (double)metaSize + (double)(textSize / 2)), (metaSize * 4 / 5 - textSize) / 2, textSize);
        } else {
            String s;
            int textDim;
            if (this.model.getHero().lives > 0) {
                textDim = (this.getSize().width - 10) / 20;
                textDim = (int)Math.floor((double)textDim / 5.0) * 5;
                s = "Victory!";
                this.drawString(g, s, (int)(((double)this.getSize().width - (double)s.length() * 1.2 * (double)textDim) / 2.0), this.getSize().height / 2 - 4 * textDim, textDim);
            } else {
                textDim = (this.getSize().width - 10) / 30;
                textDim = (int)Math.floor((double)textDim / 5.0) * 5;
                s = "You were killed";
                this.drawString(g, s, (int)(((double)this.getSize().width - (double)s.length() * 1.2 * (double)textDim) / 2.0), this.getSize().height / 2 - 5 * textDim, textDim);
                s = "in room " + this.model.getLevel();
                this.drawString(g, s, (int)(((double)this.getSize().width - (double)s.length() * 1.2 * (double)textDim) / 2.0), (int)((double)(this.getSize().height / 2) - 3.5 * (double)textDim), textDim);
            }
            g.translate(0, this.getSize().height / 2);
            textDim = (this.getSize().width - 10) / 40;
            textDim = (int)Math.floor((double)textDim / 5.0) * 5;
            s = "Your score: " + this.model.getHero().killScore + "   + " + this.model.getHero().lives + "   = " + (this.model.getHero().killScore + this.model.getHero().lives);
            this.drawString(g, s, (int)(((double)this.getSize().width - (double)s.length() * 1.2 * (double)textDim) / 2.0), 0, textDim);
            int spSize = (int)((double)textDim * 1.8 / 8.0) * 8;
            DSprite sp = new DSprite(ColorManager.getSharedManager().getColorModel("Skull"));
            sp.setPosition(new float[]{((float)(this.getSize().width / 2) + ((float)(-s.length()) / 2.0f + (float)s.indexOf(43) - 2.5f) * 1.2f * (float)textDim) / (float)spSize, 0.0f});
            this.drawSprite(g, sp, spSize);
            sp = new DSprite(ColorManager.getSharedManager().getColorModel("Heart"));
            sp.setPosition(new float[]{((float)(this.getSize().width / 2) + ((float)(-s.length()) / 2.0f + (float)s.indexOf(61) - 2.5f) * 1.2f * (float)textDim) / (float)spSize, 0.0f});
            this.drawSprite(g, sp, spSize);
            ArrayList<Collectable> gems = this.model.getOwnedGems();
            int blockDim = Math.max(8, (int)((double)(3 * textDim / 2) / 8.0) * 8);
            s = "Abilities: ";
            int textWidth = (int)((double)s.length() * 1.2 * (double)textDim);
            int textPosX = (int)(((double)this.getSize().width - ((double)textWidth + (double)((gems.size() + 1) * blockDim) * 1.5)) / 2.0);
            this.drawString(g, s, textPosX, 4 * textDim, textDim);
            int i = 0;
            while (i < gems.size()) {
                g.setColor(MagicTile.getColorByType(this.model.getOwnedGems().get((int)i).tileType));
                g.fillRect(textPosX + textWidth + (int)((double)blockDim * 1.5 * ((double)i + 0.5)), 4 * textDim - (blockDim - textDim) / 2, blockDim, blockDim);
                ++i;
            }
            s = "Press enter to continue";
            this.drawString(g, s, (int)(((double)this.getSize().width - (double)s.length() * 1.2 * (double)textDim) / 2.0), 8 * textDim, textDim);
        }
        Toolkit.getDefaultToolkit().sync();
        g.dispose();
    }

    private void drawSprite(Graphics g, DSprite s, int blockDim) {
        Color[][] colorModel = s.getColorModel();
        int i = 0;
        while (i < 8) {
            int j = 0;
            while (j < 8) {
                if (colorModel[i][j] != null) {
                    g.setColor(colorModel[i][j]);
                    g.fillRect((int)(((double)s.getPosition()[0] + (double)i / 8.0) * (double)blockDim), (int)(((double)s.getPosition()[1] + (double)j / 8.0) * (double)blockDim), (int)((double)blockDim / 8.0), (int)((double)blockDim / 8.0));
                }
                ++j;
            }
            ++i;
        }
    }

    private void drawString(Graphics g, String s, int x, int y, int blockDim) {
        this.drawString(g, s, x, y, blockDim, new Color(255, 255, 255));
    }

    private void drawString(Graphics g, String s, int x, int y, int blockDim, Color color) {
        int k = 0;
        while (k < s.length()) {
            Color[][] colorModel = ColorManager.getSharedManager().getColorModel(String.valueOf(s.charAt(k)));
            int i = 0;
            while (i < 5) {
                int j = 0;
                while (j < 5) {
                    if (colorModel[i][j] != null) {
                        g.setColor(color);
                        g.fillRect(x + (int)((double)i / 5.0 * (double)blockDim) + (int)((double)(k * blockDim) * 1.2), y + (int)((double)j / 5.0 * (double)blockDim), (int)((double)blockDim / 5.0), (int)((double)blockDim / 5.0));
                    }
                    ++j;
                }
                ++i;
            }
            ++k;
        }
    }

    private JFrame getFrame() {
        return (JFrame)SwingUtilities.getWindowAncestor(this);
    }

    public void setFullScreen(boolean fullScreen) {
        this.isFullscreen = fullScreen;
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        JFrame f = this.getFrame();
        if (gd.isFullScreenSupported() && fullScreen) {
            f.dispose();
            f.setSize(screenSize);
            f.setUndecorated(true);
            f.setLocation(0, 0);
            gd.setFullScreenWindow(f);
            f.setVisible(true);
        } else {
            Window w = gd.getFullScreenWindow();
            if (w != null) {
                w.dispose();
            }
            gd.setFullScreenWindow(null);
            f.dispose();
            f.setSize(f.getMinimumSize());
            f.setUndecorated(false);
            f.setLocation((screenSize.width - f.getSize().width) / 2, (screenSize.height - f.getSize().height) / 2);
            f.setVisible(true);
        }
    }

    public void setMouseVisible(boolean v) {
        if (v) {
            this.getFrame().getContentPane().setCursor(Cursor.getDefaultCursor());
        } else {
            BufferedImage cursorImg = new BufferedImage(16, 16, 2);
            Cursor blankCursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorImg, new Point(0, 0), "blank cursor");
            this.setCursor(blankCursor);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        float dt = 50.0f / 1000.0f;
        if (this.state == GameState.Playing) {
            this.model.update(dt);
            if (this.model.getLevel() > 6 || this.model.getHero().lives <= 0) {
                this.state = GameState.GameEnded;
            }
        } else if (this.state == GameState.WaitingForStart) {
            this.colorTimer -= dt;
            if (this.colorTimer <= 0.0f) {
                if (this.sweepingTitle) {
                    ++this.coloredLetter;
                    this.randColor = MagicTile.getColorByType(MagicTile.TileType.values()[(int)(Math.random() * (double)MagicTile.TileType.values().length - 1.0)]);
                    this.colorTimer = 0.1f;
                    if (this.coloredLetter >= "POWER GROUNDS".length()) {
                        this.sweepingTitle = false;
                        this.coloredLetter = -1;
                    }
                } else if (this.coloredLetter < 0) {
                    this.colorTimer = (float)(0.1 + Math.random() * (double)0.7f);
                    this.coloredLetter = (int)(Math.random() * (double)"POWER GROUNDS".length());
                    this.randColor = MagicTile.getColorByType(MagicTile.TileType.values()[(int)(Math.random() * (double)MagicTile.TileType.values().length - 1.0)]);
                } else {
                    this.colorTimer = (float)(Math.random() * 1.0);
                    this.coloredLetter = -1;
                    double rand = Math.random();
                    this.sweepingTitle = rand < 0.03;
                }
            }
        }
        this.repaint();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.setFullScreen(!this.isFullscreen);
        } else if (this.state == GameState.WaitingForStart) {
            if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                this.initGame();
            }
        } else if (this.state == GameState.Playing) {
            if (e.getKeyCode() == 37 || e.getKeyCode() == 65) {
                this.model.moveHero(3);
            } else if (e.getKeyCode() == 39 || e.getKeyCode() == 68) {
                this.model.moveHero(1);
            } else if (e.getKeyCode() == 38 || e.getKeyCode() == 87) {
                this.model.moveHero(0);
            } else if (e.getKeyCode() == 40 || e.getKeyCode() == 83) {
                this.model.moveHero(2);
            } else if (e.getKeyCode() == 32) {
                this.model.castSpell();
            }
        } else if (this.state == GameState.GameEnded && (e.getKeyCode() == 10 || e.getKeyCode() == 32)) {
            this.state = GameState.WaitingForStart;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseX = e.getPoint().x;
        this.mouseY = e.getPoint().y;
    }

    public static enum GameState {
        WaitingForStart,
        Playing,
        GameEnded;

    }
}

