/*
 * Decompiled with CFR 0.152.
 */
package roguelike;

import roguelike.ColorManager;
import roguelike.Element;
import roguelike.Enemy;
import roguelike.Global;
import roguelike.MapManager;
import roguelike.Projectile;

public class EnemyRanged
extends Enemy {
    public EnemyRanged(MapManager map) {
        super(map);
        this.name = "EnemyRangedL";
        this.colorModel = ColorManager.getSharedManager().getColorModel("EnemyRangedL");
    }

    @Override
    public void move() {
        if (this.stunCount > 0) {
            this.updateCooldowns();
            return;
        }
        int[] dir = this.getOptimalDirection(Enemy.MovePriority.GetAlligned);
        boolean couldHit = false;
        if (Math.abs(this.map.getHero().getSlot()[0] - this.getSlot()[0]) + Math.abs(this.map.getHero().getSlot()[1] - this.getSlot()[1]) <= 3.0f && (this.map.getHero().getSlot()[0] == this.getSlot()[0] && dir[1] != 0 || this.map.getHero().getSlot()[1] == this.getSlot()[1] && dir[0] != 0)) {
            int i = 0;
            while (i < 8) {
                Element e = this.map.getElementAt(this.getSlot()[0] + (float)(i * dir[0]), this.getSlot()[1] + (float)(i * dir[1]));
                if (this.getSlot()[0] + (float)(i * dir[0]) == this.map.getHero().getSlot()[0] && this.getSlot()[1] + (float)(i * dir[1]) == this.map.getHero().getSlot()[1]) {
                    couldHit = true;
                    Projectile p = new Projectile(Global.getIntFromDir(new float[]{dir[0], dir[1]}), Projectile.ProjectileType.Arrow, false);
                    p.setPosition(this.getPosition());
                    this.map.addProjectile(p);
                    break;
                }
                if (e != null && e.getType() == Element.ElementType.kTypeWall) break;
                ++i;
            }
        }
        if (!(couldHit || dir[0] == 0 && dir[1] == 0)) {
            float[] nextPos = new float[]{this.nextPosX + (float)dir[0], this.nextPosY + (float)dir[1]};
            this.map.elementMoving(this.getSlot(), nextPos);
            super.moveTo(nextPos);
            if (this.nextPosX > this.positionX) {
                this.name = "EnemyRangedR";
                this.colorModel = ColorManager.getSharedManager().getColorModel("EnemyRangedR");
            } else if (this.nextPosX < this.positionX) {
                this.name = "EnemyRangedL";
                this.colorModel = ColorManager.getSharedManager().getColorModel("EnemyRangedL");
            }
        }
    }
}

