/*
 * Decompiled with CFR 0.152.
 */
package roguelike;

import java.awt.Color;
import roguelike.ColorManager;
import roguelike.Element;
import roguelike.Global;
import roguelike.MagicTile;
import roguelike.SoundManager;
import roguelike.Unit;

public class Hero
extends Unit {
    private int direction = 2;
    public int lives = 2;
    public int stamina = 1;
    public int killScore;
    public boolean shield;
    public int offensiveIndex;
    public int defensiveIndex;
    public int quickIndex;
    public boolean willThrow;
    public boolean willDash;
    public boolean dashing;

    public Hero() {
        super(Element.ElementType.kTypeHero);
        this.setColorModel();
    }

    public void moveTo(float nextPosX, float nextPosY) {
        int dir = 2;
        if (nextPosX > this.nextPosX) {
            dir = 1;
        } else if (nextPosX < this.nextPosX) {
            dir = 3;
        } else if (nextPosY > this.nextPosY) {
            dir = 2;
        } else if (nextPosY < this.nextPosY) {
            dir = 0;
        }
        this.nextPosX = nextPosX;
        this.nextPosY = nextPosY;
        this.direction = dir;
        this.setColorModel();
        if (this.quickIndex <= 0 || this.stamina >= 2) {
            SoundManager.getSharedManager().playSound("move.wav");
        }
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int dir) {
        this.direction = dir;
        this.setColorModel();
    }

    public void setNextPos(float posX, float posY) {
        this.nextPosX = posX;
        this.nextPosY = posY;
    }

    public void setDashing(boolean dashing) {
        this.velocity = dashing ? 12.0f : 6.0f;
        this.dashing = dashing;
    }

    public void castOffensiveStance() {
        this.offensiveIndex = 2;
        this.defensiveIndex = 0;
        this.quickIndex = 0;
        this.setColorModel();
    }

    public void castDefensiveStance() {
        this.offensiveIndex = 0;
        this.defensiveIndex = 3;
        this.quickIndex = 0;
        this.setColorModel();
    }

    public void castQuickStance() {
        this.offensiveIndex = 0;
        this.defensiveIndex = 0;
        this.quickIndex = 4;
        this.stamina = 2;
        this.setColorModel();
    }

    private void setColorModel() {
        Color newColor = new Color(75, 75, 75);
        if (this.offensiveIndex > 0) {
            newColor = MagicTile.getColorByType(MagicTile.TileType.OffensiveStance);
            newColor = newColor.darker();
        } else if (this.defensiveIndex > 0) {
            newColor = MagicTile.getColorByType(MagicTile.TileType.DefensiveStance);
            newColor = newColor.darker();
        } else if (this.quickIndex > 0) {
            newColor = MagicTile.getColorByType(MagicTile.TileType.QuickStance);
            newColor = newColor.darker();
        }
        this.colorModel = ColorManager.getSharedManager().getColorModel("Hero " + this.direction, new Color(255, 0, 255), newColor);
    }

    public void consumeCharge() {
        if (this.quickIndex > 0) {
            --this.quickIndex;
        } else if (this.offensiveIndex > 0) {
            --this.offensiveIndex;
        } else if (this.defensiveIndex > 0) {
            SoundManager.getSharedManager().playSound("move.wav");
            --this.defensiveIndex;
        }
        this.setColorModel();
    }

    public void consumeAllCharges() {
        this.offensiveIndex = 0;
        this.defensiveIndex = 0;
        this.quickIndex = 0;
        this.setColorModel();
    }

    public int getCharges() {
        if (this.quickIndex > 0) {
            return this.quickIndex;
        }
        if (this.offensiveIndex > 0) {
            return this.offensiveIndex;
        }
        if (this.defensiveIndex > 0) {
            return this.defensiveIndex;
        }
        return 0;
    }

    public void tackle(int dir) {
        this.tackleDestination = new float[]{this.getSlot()[0] + Global.getVectorFromDir(dir)[0], this.getSlot()[1] + Global.getVectorFromDir(dir)[1]};
        SoundManager.getSharedManager().playSound("hit.wav");
    }
}

